<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;
class course extends Widget_Base {
	public function get_name() {
		return __( 'yog-course', 'yog-core' );
	}
	public function get_title() {
		return __( 'course', 'yog-core' );
	}
	public function get_categories() {
		return [ 'yog-core' ];
	}
	protected function _register_controls() {
        $this->start_controls_section(
			'course_section',
			[
				'label' => __( 'Courses', 'yog-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
            'card_style',
            [
                'label' => __( 'Card Style', 'yog-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
					'1'              => __( 'Style One', 'yog-core' ),
					'2'              => __( 'Style Two ', 'yog-core' ),
					'3'              => __( 'Style Three', 'yog-core' ),
					'4'              => __( 'Style Four', 'yog-core' ),
					
				],
				'default' => '1',
           ]
        );
        $this->add_control(
            'order',
            [
                'label' => __( 'Courses Order By', 'yog-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'      => __( 'DESC', 'yog-core' ),
                    'ASC'       => __( 'ASC', 'yog-core' ),
                ],
                'default' => 'DESC',
            ]
        );
        $this->add_control(
			'count',
			[
				'label' => __( 'Count', 'yog-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 3,
			]
        );
        $this->end_controls_section();
        $this->start_controls_section(
			'section_Jnza49QH5b77duo',
			[
				'label' => __( 'Button', 'yog-core' ),
				// 'condition' => [
				// 	'card_style' => '2',
				// ]
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' => __( 'Button Text', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Read More', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );
			
		$this->end_controls_section();
		// $this->start_controls_section(
		// 	'section_slider_control',
		// 	[
		// 		'label' => __( 'Slider Control', 'interior-core' ),
		// 		// 'condition' => [
		// 		// 	'card_style' => 'slider',
		// 		// ]
		// 	]
		// );
		// $this->add_control(
  //           'slider_style',
  //           [
  //               'label' => __( 'Card Style', 'yog-core' ),
  //               'type' => Controls_Manager::SELECT,
  //               'options' => [
		// 			'1'              => __( 'Style One', 'yog-core' ),
		// 			'2'              => __( 'Style Two ', 'yog-core' ),
		// 			'3'              => __( 'Style Three', 'yog-core' ),
		// 			'4'              => __( 'Style Four', 'yog-core' ),
					
		// 		],
		// 		'default' => '1',
  //          ]
  //       );
		// require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-control.php';
		// $this->end_controls_section();
    }
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/lp_course.php';
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\course() );