<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class gymList extends Widget_Base {

	public function get_name() {
		return __( 'yog_list', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'List', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}


	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-editor-list-ul';
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'list_section',
			[
				'label' => __( 'List', 'yog-core' ),
			]
		);

		
		$this->add_control(
			'list_icon',
			[
				'label' => __( 'List Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'fa-solid',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				
				
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'list_item',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'List Item', 'yog-core' ),
				'default' => __( 'List Item', 'yog-core' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'after',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				]
			]
		);
        
        
        $this->add_control(
			'list',
			[
				'label' => __( 'List', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_item' => __( 'List 1', 'yog-core' ),
						
					]
					
				]
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/list.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\gymList() );