<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 
class Imgslider extends Widget_Base {
	public function get_name() {
		return __( 'imageslider', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Image Slider', 'yog-core' );
	}
	public function get_categories() {
		return [ 'yog-core' ];
    }
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-testimonial-carousel';
	}
	protected function _register_controls() {
		
		$this->start_controls_section(
			'img_slider',
			[
				'label' => __( 'ImageSlider', 'yog-core' ),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				
				
			]
		);
		
		$this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
				
						
						'image' => Utils::get_placeholder_image_src(),
					],
			]
		);
		
		
        $this->end_controls_section();

        $this->start_controls_section(
			'section__2p08cZ',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		 $this->add_responsive_control(
			'content_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],
					
				],
				
			]
		);
		$this->end_controls_section();

       

		 $this->start_controls_section(
			'section_slider_control',
			[
				'label' => __( 'Slider Control', 'interior-core' ),
			]
		);
		require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-control.php';

		$this->end_controls_section();

	}
	
	
	protected function render() {
		$settings = $this->get_settings();
         require_once YOG_PLUGIN_DIR . '/includes/elementor/widget/imageslider/style-1.php';

          if ( Plugin::$instance->editor->is_edit_mode() ) :
         	require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-common-js.php';
         endif; 

    }	    
		
}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Imgslider() );