<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Image_effect extends Widget_Base {

	public function get_name() {
		return __( 'yog_Image_effect', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'gym Image effect', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-image';
	}

	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'yog_Image_effect Box', 'yog-core' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],				
				
			]
		);

		
		$this->end_controls_section();

		$this->start_controls_section(
			'content_section_9866ea3',
			[
				'label' => __( 'Image Style', 'plugin-name' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'effect_direction',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'lr',
				'options'    => [
					'lr'       => __( 'Left To Right', 'yog-core' ),
					'rl'          => __( 'Right To Left', 'yog-core' ),
					'bt'          => __( 'Come From Bottom', 'yog-core' ),
					'tb'          => __( 'Come From Top', 'yog-core' ),
					
				],
			]
		);

		$this->add_control(
			'effect_color',
			[
				'label' => __( 'Effect Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,		
				
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'custom_size', 				
				'include' => [],
				'default' => 'large',
			]
		);

		$this->add_responsive_control(
			'align_image',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],
					
				],
				'selectors' => [
					'{{WRAPPER}} .content__image-wrap' => 'text-align: {{VALUE}};',
					
				],
			]
		);	


		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/image-effect.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Image_effect() );