<?php

namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) exit; 



class Fancybox extends Widget_Base {



	public function get_name() {

		return __( 'myfancybox', 'yog-core' );

	}

	

	public function get_title() {

		return __( 'Fancybox', 'yog-core' );

	}



	public function get_categories() {

		return [ 'yog-core' ];

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve counter widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-info-box';

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section',

			[

				'label' => __( 'Style', 'yog-core' ),

			]

		);

		

         $this->add_control(

			'fancy_style',

			[

				'label' => __( 'Select Style', 'plugin-domain' ),

				'type' => Controls_Manager::SELECT,

				'default' => '1',

				'options' => [

					'1'  => __( 'Style 1', 'plugin-domain' ),

					'2' => __( 'Style 2', 'plugin-domain' ),

					'3' => __( 'Style 3', 'plugin-domain' ),

					'4' => __( 'Style 4', 'plugin-domain' ),

					

				],

			]

		);

        $this->end_controls_section();

		$this->start_controls_section(

			'section_image',

			[

				'label' => __( 'Fancybox Box', 'yog-core' ),

			]

		);

		$this->add_control(

			'image_style',

			[

				'label'      => __( 'Choose Image/Icon', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'none',

				'options'    => [

					'none'       => __( 'None', 'yog-core' ),

					'1'          => __( 'Image', 'yog-core' ),

					'2'          => __( 'Icon', 'yog-core' ),

					

				],


			]

		);

		$this->add_control(

			'image',

			[

				'label' => __( 'Choose Image', 'yog-core'),

				'type' => Controls_Manager::MEDIA,

				'dynamic' => [

					'active' => true,

				],

				

				'condition' => [

					'image_style' => '1',

				],

			]

		);

		$this->add_control(

			'selected_icon',

			[

				'label' => __( 'Icon', 'yog-core' ),

				'type' => Controls_Manager::ICONS,

				'label_block' => true,

				'default' => [

					'value' => 'fas fa-check',

					'library' => 'fa-solid',

				],

                'fa4compatibility' => 'icon',

				'separator' => 'before',

				'condition' => [

					'image_style' => '2',

				]

			]

		);

		$this->add_control(

			'sub_title_hides',

			[

				'label' => __( 'hide Sub title', 'yog-core' ),

				'type' => Controls_Manager::SWITCHER,

				'default' => 'yes',

				'yes' => __( 'yes', 'yog-core' ),

				'no' => __( 'no', 'yog-core' ),

			]

        );

		$this->add_control(

			'sub_title_text',

			[

				'label' => __( 'Sub title', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sub sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

				'condition' => ['sub_title_hides' => 'yes'],


			]



        );

       

		

		$this->add_control(

			'title_text',

			[

				'label' => __( 'Title', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

			]

        );

        $this->add_control(

			'title_tag',

			[

				'label' => __( 'Title Tag', 'plugin-domain' ),

				'type' => Controls_Manager::SELECT,

				'default' => 'h5',

				'options' => [

					'h1'  => 'h1',

					'h2'  => 'h2',

					'h3'  => 'h3',

					'h4'  => 'h4',

					'h5'  => 'h5',

					'h6'  => 'h6',

					'p'  => 'p',

					'span'  => 'span',

					

				],

				

			]

			

		);

        $this->add_control(

			'desc_hides',

			[

				'label' => __( 'hide description', 'yog-core' ),

				'type' => Controls_Manager::SWITCHER,

				// 'default' => 'yes',

				'yes' => __( 'yes', 'yog-core' ),

				'no' => __( 'no', 'yog-core' ),

				'return_value' => 'yes',

			]

        );

		$this->add_control(

			'description_text',

			[

				'label' => __( 'Content', 'yog-core' ),

				'type' => Controls_Manager::WYSIWYG,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'Enter your Description here', 'yog-core' ),

				'placeholder' => __( 'Enter your description', 'yog-core' ),

				'separator' => 'before',

				'rows' => 10,

				'show_label' => true,

				'condition' => [

					'desc_hides' => 'yes',

				]

			]

		);



		 $this->add_control(

			'style_text',

			[

				'label' => __( 'number', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'label_block' => true,

			]



        );



		$repeater = new Repeater();

        $repeater->add_control(

			'tab_title',

			[

				'label' => __( 'Plan info List', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'default' => __( 'List Item', 'yog-core' ),

				'placeholder' => __( 'List Item', 'yog-core' ),

				'label_block' => true,

			]

		);

        



        

        $this->add_control(

			'tabs',

			[

				'label' => __( 'List Items', 'yog-core' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => $repeater->get_controls(),

				'default' => [

					[

						'tab_title' => __( 'Tab #1', 'yog-core' ),

						

                        

					]

					

				],

				'title_field' => '{{{ tab_title }}}',

			]

		);

		  $this->add_control(

			'button_switch',

			[

				'label' => __( 'Button', 'yog-core' ),

				'type' => Controls_Manager::SWITCHER,

				'yes' => __( 'yes', 'yog-core' ),

				'no' => __( 'no', 'yog-core' ),

				'return_value' => 'yes',





			]

        );

		

		$this->end_controls_section();

		$this->start_controls_section(

			'section_Jnza43wt8d9QH5b77duo',

			[

				'label' => __( 'Button', 'yog-core' ),

				 'condition' => [

				 	'button_switch' => 'yes',

				 ],



			]

		);

			require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_controls.php';



		//$this->end_controls_section();

		//icon background

		

		 $this->start_controls_section(

			'section_a84320g2u',

			[

				'label' => __( 'Background', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



         $this->start_controls_tabs( 'tabs_2a023sGfU' );

         $this->start_controls_tab(

            'tabs_tJ74N2F',

            [

                'label' => __( 'Normal', 'elementor' ),

            ]

        );



         $this->add_group_control(

            Group_Control_Background::get_type(),

            [

                'name' => 'box_background_WA2eRT534bw2a',

                'label' => __( 'Background', 'yog-core' ),

                'types' => [ 'classic', 'gradient' ],

                'selector' => '{{WRAPPER}} .gt-fancy-box ',

            ]

        );

  

         $this->end_controls_tab();



         

         $this->end_controls_tabs();

		 $this->end_controls_section();



		 

		  $this->start_controls_section(

			'section_a820g2u',

			[

				'label' => __( 'Icon Box', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



         $this->start_controls_tabs( 'tabs_2a0sGfU' );

         $this->start_controls_tab(

            'tabs_tJ74N652F',

            [

                'label' => __( 'Normal', 'elementor' ),

            ]

        );



         $this->add_group_control(

            Group_Control_Background::get_type(),

            [

                'name' => 'box_background_WA2eRTbw2a',

                'label' => __( 'Background', 'yog-core' ),

                'types' => [ 'classic', 'gradient' ],

                'selector' => '{{WRAPPER}} i.fas.fa-check',

            ]

        );

         $this->add_control(

			'color__BbYaUJF3',

			[

				'label' => __( 'Icon Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} i.fas.fa-check' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);

         $this->add_responsive_control(

			'icon_size',

			[

				'label' => __( 'Size', 'elementor' ),

				'type' => Controls_Manager::SLIDER,

				'default' => [

					'size' => 14,

				],

				'range' => [

					'px' => [

						'min' => 6,

					],

				],

				'selectors' => [

					'{{WRAPPER}} i.fas.fa-check' => 'font-size: {{SIZE}}{{UNIT}};',

					

				],

			]

		);

        

         $this->end_controls_tab();



         $this->start_controls_tab(

            'tabs__Ax450ea',

            [

                'label' => __( 'Hover', 'elementor' ),

            ]

        );

         $this->add_group_control(

            Group_Control_Background::get_type(),

            [

                'name' => 'box_background__o5Pa8H8',

                'label' => __( 'Background', 'yog-core' ),

                'types' => [ 'classic', 'gradient' ],

                'selector' => '{{WRAPPER}} i.fas.fa-check:hover',

            ]

        );





       





         $this->end_controls_tabs();

         



       

		 $this->end_controls_section();



		 



		 // Title Style







		 $this->start_controls_section(

			'section__2p08cZ1',

			[

				'label' => __( 'Title', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



        



         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography_kpscb63',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancy-box-title',

				              //'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-style-2 .gt-fancy-box-content .gt-fancy-box-heading',



				



			]

		);



 		$this->add_control(

			'title_color__BbYUJF3',

			[

				'label' => __( 'TItle Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-fancy-box-title' => 'color: {{VALUE}};',

					'{{WRAPPER}} h5.gt-fancy-box-heading' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);



		



		// Spacing



		

        



        

         

         $this->end_controls_section();

        

         // sub titile 



         $this->start_controls_section(

			'section__85db3fF',

			[

				'label' => __( 'Sub Title', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'typography__74ile76',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancybox-sub-title',

			]

		);

          $this->add_control(

			'color__74ile76',

			[

				'label' => __( 'Text Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-fancy-box .gt-fancybox-sub-title' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);

         

 

         $this->end_controls_tab();

         $this->end_controls_tabs();

         $this->end_controls_section();



         $this->start_controls_section(

			'section__74ile76',

			[

				'label' => __( 'Description', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'typography__74ile7s6',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancybox-description',

				              //'{{WRAPPER}} p.gt-fancy-box-description',



				

			]

		);

           $this->add_control(

			'color__74iled76',

			[

				'label' => __( 'Text Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-fancy-box .gt-fancybox-description' => 'color: {{VALUE}};',

					'{{WRAPPER}} p.gt-fancy-box-description' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);



  		

		$this->end_controls_tab();

         $this->end_controls_tabs();        

		 $this->end_controls_section();





		   $this->start_controls_section(

			'section__74ile789',

			[

				'label' => __( 'Number', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'typography__74ilewer',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-fancy-box-style-2 .gt-fancy-box-media span',

				             



				

			]

		);

           $this->add_control(

			'color__74iled5',

			[

				'label' => __( 'Text Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-fancy-box-style-2 .gt-fancy-box-media span' => 'color: {{VALUE}};',

					

		 		],

				

				

			]

		);





  		

		$this->end_controls_tab();

         $this->end_controls_tabs();        

		 $this->end_controls_section();







		 $this->start_controls_section(

			'section__2p08cZ',

			[

				'label' => __( 'Alignment', 'interior-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

		 $this->add_responsive_control(

			'content_align',

			[

				'label' => __( 'Alignment', 'interior-core' ),

				'type' => Controls_Manager::CHOOSE,

				'options' => [

					'text-left' => [

						'title' => __( 'Left', 'interior-core' ),

						'icon' => 'eicon-text-align-left',

					],

					'text-center' => [

						'title' => __( 'Center', 'interior-core' ),

						'icon' => 'eicon-text-align-center',

					],

					'text-right' => [

						'title' => __( 'Right', 'interior-core' ),

						'icon' => 'eicon-text-align-right',

					],

					

				],

				

			]

		);

		$this->end_controls_section();

	}

	

	protected function render() {

		$settings = $this->get_settings();

        require YOG_PLUGIN_DIR . '/includes/elementor/render/fancybox.php';

    }	    

		

}



Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Fancybox() );