<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Fancysboxs extends Widget_Base {

	public function get_name() {

		return __( 'fancybox', 'yog-core' );

	}

	

	public function get_title() {

		return __( 'Fancybox-slider', 'yog-core' );

	}

	public function get_categories() {

		return [ 'yog-core' ];

	}

	/**

	* Get widget icon.

	*

	* Retrieve counter widget icon.

	*

	* @since 1.0.0

	* @access public

	*

	* @return string Widget icon.

	*/

	public function get_icon() {

		return 'eicon-info-box';

	}

	protected function _register_controls() {

		$this->start_controls_section(

			'section',

			[

				'label' => __( 'Style', 'yog-core' ),

			]

		);



		$this->add_control(

            'fancy_style',

            [

                

                'type' => 'image_select_control',

                'option' => [

                				'1' => YOG_PLUGIN_URL.'/assests/img/fancybox/1.png', 

                				// '2' => YOG_PLUGIN_URL.'/assests/img/fancybox/2.png', 

                				// '3' => YOG_PLUGIN_URL.'/assests/img/fancybox/3.png', 

                				'2' => YOG_PLUGIN_URL.'/assests/img/fancybox/4.png', 

                				

                				

                			],

                'description' => __('This is description' , 'yog-core')

            ]

        );



        $this->end_controls_section();

		$this->start_controls_section(

			'section_image',

			[

				'label' => __( 'FancyBox Slider', 'yog-core' ),

			]

		);



		$repeater = new Repeater();





		$repeater->add_control(

			'image_style',

			[

				'label'      => __( 'Choose Image/Icon', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'none',

				'options'    => [

					'none'       => __( 'None', 'yog-core' ),

					'1'          => __( 'Image', 'yog-core' ),

					'2'          => __( 'Icon', 'yog-core' ),

					

				],

			]

		);



		



		$repeater->add_control(

			'image',

			[

				'label' => __( 'Choose Image', 'yog-core'),

				'type' => Controls_Manager::MEDIA,

				'dynamic' => [

					'active' => true,

				],

				

				'condition' => [

					'image_style' => '1',

				],

			]

		);



		

		



		$repeater->add_control(

			'selected_icon',

			[

				'label' => __( 'Icon', 'yog-core' ),

				'type' => Controls_Manager::ICONS,

				'label_block' => true,

				'default' => [

					'value' => 'ion ion-android-arrow-dropright',

					

				],

                'fa4compatibility' => 'icon',

				'separator' => 'before',

				'condition' => [

					'image_style' => '2',

				]

			]

		);



		



		$repeater->add_control(

			'title_text',

			[

				'label' => __( 'Title', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sub sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

			]

        );


        $repeater->add_control(

			'step_text',

			[

				'label' => __( 'Step Title', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is step sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your Step title', 'yog-core' ),

				'label_block' => true,
				// 'condition' => [

				// 	'fancy_style' => '1',

				// ]


			]

        );



        $repeater->add_control(

			'style_text',

			[

				'label' => __( 'Fancy number', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'label_block' => true,

				'condition' => [

					'fancy_style' => '2',

				]


			]

        );



        $repeater->add_control(

			'title_tag',

			[

				'label' => __( 'Title Tag', 'plugin-domain' ),

				'type' => Controls_Manager::SELECT,

				'default' => 'h5',

				'options' => [

					'h1'  => 'h1',

					'h2'  => 'h2',

					'h3'  => 'h3',

					'h4'  => 'h4',

					'h5'  => 'h5',

					'h6'  => 'h6',

					'p'  => 'p',

					'span'  => 'span',

					

				],

				

			]

			

		);



      



       

		$repeater->add_control(

			'description_text',

			[

				'label' => __( 'Content', 'yog-core' ),

				'type' => Controls_Manager::WYSIWYG,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'Enter your Description here', 'yog-core' ),

				'placeholder' => __( 'Enter your description', 'yog-core' ),

				'separator' => 'before',

				'rows' => 10,

				'show_label' => true,

			]

		);



		 $repeater->add_control(

			'btn_link',

			[

				'label' => __( 'Link', 'yog-core' ),

				'type' => Controls_Manager::URL,

				'dynamic' => [

					'active' => true,

				],

				'placeholder' => __( 'https://your-link.com', 'yog-core' ),

				'separator' => 'before',

			]

		);	



		 $repeater->add_control(

			'button_text',

			[

				'label' => __( 'Button Text', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'Click Here', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

			]

        );

		



        



		



		$this->add_control(

			'tabs',

			[

				'label' => __( 'Tabs Items', 'yog-core' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => $repeater->get_controls(),

				'default' => [

					[

						'title_text' => __( 'fancy Box', 'yog-core' ),

						

						

					]

				]

			]

		);



		$this->add_control(

			'desk_num',

			[

				'label' => __( 'Desktop number', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( '3', 'yog-core' ),				

				'separator' => 'before',

				

			]

        );

        $this->add_control(

			'lap_num',

			[

				'label' => __( 'Laptop number', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( '3', 'yog-core' ),				

				'separator' => 'before',

				

			]

        );



        $this->add_control(

			'tab_num',

			[

				'label' => __( 'Tablet number', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( '2', 'yog-core' ),				

				'separator' => 'before',

				

			]

        );



        $this->add_control(

			'mob_num',

			[

				'label' => __( 'Mobile number', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( '1', 'yog-core' ),				

				'separator' => 'before',

				

			]

        );



        $this->add_control(

			'autoplay',

			[

				'label'      => __( 'Autoplay', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'true',

				'options'    => [

					'true'       => __( 'True', 'yog-core' ),

					'false'          => __( 'False', 'yog-core' ),				

					

				],

				

			]

		);

		$this->add_control(

			'loop',

			[

				'label'      => __( 'Loop', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'true',

				'options'    => [

					'true'       => __( 'True', 'yog-core' ),

					'false'          => __( 'False', 'yog-core' ),				

					

				],

				

			]

		);



		$this->add_control(

			'nav_arrow',

			[

				'label'      => __( 'Navigation Arrow', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'true',

				'options'    => [

					'true'       => __( 'True', 'yog-core' ),

					'false'          => __( 'False', 'yog-core' ),				

					

				],

				

			]

		);

		$this->add_control(

			'dots',

			[

				'label'      => __( 'Dots', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'true',

				'options'    => [

					'true'       => __( 'True', 'yog-core' ),

					'false'          => __( 'False', 'yog-core' ),				

					

				],

				

			]

		);



		$this->add_responsive_control(

			'margin',

			[

				'label' => __( 'Space', 'elementor' ),

				'type' => Controls_Manager::SLIDER,

				'default' => [

					'size' => 30,

				],

				'range' => [

					'px' => [

						'min' => 0,

						'max' => 100,

					],

				],

				

				

			]

		);





		$this->add_responsive_control(

			'text_align',

			[

				'label' => __( 'Alignment', 'yog-core' ),

				'type' => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => __( 'Left', 'yog-core' ),

						'icon' => 'eicon-text-align-left',

					],

					'center' => [

						'title' => __( 'Center', 'yog-core' ),

						'icon' => 'eicon-text-align-center',

					],

					'right' => [

						'title' => __( 'Right', 'yog-core' ),

						'icon' => 'eicon-text-align-right',

					]

				],

				'selectors' => [

					'{{WRAPPER}} .gt-fancy-box-slider .gt-fancybox-box-info' => 'text-align: {{VALUE}}',

				],

			]

		);

	

		$this->end_controls_section();

		





	

		// Button Style Section

		$this->start_controls_section(

			'section_y8ubBfbAH1e2VwpN5be9',

			[

				'label' => __( 'Button Style', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

				

			]

		);



		$this->add_control(

            'btn_style',

            [   

                'type' => 'image_select_control',

                'option' => [

                				'btn-flat' => 'https://via.placeholder.com/200x80.png?text=btn-flat', 

                				'btn-outline' => 'https://via.placeholder.com/200x80.png?text=btn-outline', 

                				'btn-link' => 'https://via.placeholder.com/200x80.png?text=btn-link', 

                				

                			],

                'description' => __('This is description' , 'yog-core')

            ]

        );

        

         

		$this->add_group_control(

			\Elementor\Group_Control_Typography::get_type(),

			[

				'name' => 'content_typography',

				'label' => __( 'Typography', 'plugin-domain' ),

				'scheme' => Scheme_Typography::TYPOGRAPHY_1,

				'selector' => '{{WRAPPER}} .gt-button-block .gt-button span',

			]

		);



		$this->start_controls_tabs( 'tabs_button_style' );



		$this->start_controls_tab(

			'tab_button_normal',

			[

				'label' => __( 'Normal', 'elementor' ),

			]

		);



		$this->add_control(

			'button_text_color',

			[

				'label' => __( 'Text Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'selectors' => [

					'{{WRAPPER}} .gt-button-block .gt-button span' => 'color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'background_color',

			[

				'label' => __( 'Background Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-button' => 'background-color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'background_color1',

			[

				'label' => __( 'Background Line Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-button .gt-button-line-left' => 'background-color: {{VALUE}};',

				],

			]

		);





		$this->end_controls_tab();



		$this->start_controls_tab(

			'tab_button_hover',

			[

				'label' => __( 'Hover', 'elementor' ),

			]

		);



		$this->add_control(

			'hover_color',

			[

				'label' => __( 'Text Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-button-block .gt-button:hover span' => 'color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'button_background_hover_color',

			[

				'label' => __( 'Background Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-button::before' => 'background-color: {{VALUE}};',

				],

			]

		);

		$this->add_control(

			'button_background_hover_color1',

			[

				'label' => __( 'Background Line Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-button:hover .gt-button-line-left' => 'background-color: {{VALUE}};',

				],

			]

		);

		



		$this->end_controls_tab();





		$this->end_controls_tabs();



		$this->end_controls_section();



		



		//$this->end_controls_section();

		$this->start_controls_section(

			'section_Jnza43wt8d9454QH5b77werwduo',

			[

				'label' => __( 'bullets Colours ', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

		$this->add_control(

			'border_color__d2VjaFs4F4',

			[

				'label' => __( 'Bullet Active Color', 'yog-core' ),				

				'type' => Controls_Manager::COLOR,

				

				'selectors' => [

					'{{WRAPPER}}  .owl-carousel .owl-dots .owl-dot.active' => 'background: {{VALUE}};',

		 		],

				

				

			]

		);





		$this->add_control(

			'border_color__d2VjaFgfs4F4',

			[

				'label' => __( 'Bullet Default Color', 'yog-core' ),				

				'type' => Controls_Manager::COLOR,

				

				'selectors' => [

					'{{WRAPPER}}  .owl-carousel .owl-dots .owl-dot' => 'background: {{VALUE}};',

		 		],

				

				

			]

		);

		$this->end_controls_section();

     $this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Colors', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'bg_color',
			[
				'label' => __( 'Background Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box-slider.gt-fancy-box-slider-1' => 'background-color: {{VALUE}};',
					
		 		],
				
				
			]
		);


		$this->add_control(

			'icon_color',
			[
				'label' => __( 'Icon', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-media i' => 'color: {{VALUE}};',
					
		 		],
				
				
			]
		);

            $this->add_control(
			'title_color',
			[
				'label' => __( 'Title', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-content h5' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		
		
		$this->add_control(
			'desc_color',
			[
				'label' => __( 'Description', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-content p' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'step_title_color',
			[
				'label' => __( 'Step Title', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-step' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		
		
		 $this->end_controls_section();

		 $this->start_controls_section(
			'section__2p08Zt',
			[
				'label' => __( 'Typography', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		

		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Tittle', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancy-box-content h5'
				
			]
		);

		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'descrition_typography',
				'label' => __( 'Description', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancy-box-content p',
			]
		);

		  $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'steptitle_typography',
				'label' => __( 'Step Tittle', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancy-box-step',
			]
		);

		 $this->end_controls_section();





	}

	protected function render() {

		$settings = $this->get_settings();

		require YOG_PLUGIN_DIR . '/includes/elementor/render/fancybox-slider.php';

		 if ( Plugin::$instance->editor->is_edit_mode() ) : ?>



<script>	

			 jQuery('p:empty').remove();	



		jQuery('.owl-carousel').each(function() {

           var app_slider = jQuery(this);

          

          

           

           app_slider.owlCarousel({

               items: app_slider.data("desk_num"),

               loop: app_slider.data("loop"),

               margin: app_slider.data("margin"),

               nav: app_slider.data("nav"),

               dots: app_slider.data("dots"),

               autoplay: app_slider.data("autoplay"),

               autoplayTimeout: app_slider.data("autoplay-timeout"),

               navText: ["<i class='ion-ios-arrow-back'></i><span>Prev</span>", "<span>Next</span><i class='ion-ios-arrow-forward'></i>"],

               responsiveClass: true,

               responsive: {

                   // breakpoint from 0 up

                   0: {

                       items: app_slider.data("mob_sm"),

                       nav: false,

                        //dots: true

                   },

                   // breakpoint from 480 up

                   480: {

                       items: app_slider.data("mob_num"),

                       nav: false,

                       // dots: true

                   },

                   // breakpoint from 786 up

                   786: {

                       items: app_slider.data("tab_num")

                   },

                   // breakpoint from 1023 up

                   1023: {

                       items: app_slider.data("lap_num")

                   },

                   1199: {

                       items: app_slider.data("desk_num")

                   }

               }

           });

       });

		</script>

		

		<?php endif; 

    }	    

}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Fancysboxs() );