<?php
namespace Elementor;
if (!defined('ABSPATH')) {
	exit;
}

class yog_counter extends Widget_Base {

	public function get_name() {
		return __('gym-counter', 'yog-core');
	}

	public function get_title() {
		return __('Counter', 'yog-core');
	}

	public function get_categories() {
		return ['yog-core'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve button widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-counter';
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);

		$this->add_control(
            'counter_style',
            [
                
                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/counter/1.png', 
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
			'section_image',
			[
				'label' => __('Counter', 'yog-core'),
			]
		);

		 $this->add_control(
			'show_media',
			[
				'label' => __( 'Show Media', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'yog-core' ),
				'label_off' => __( 'Hide', 'yog-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'image_style',
			[
				'label' => __('Choose Image/Icon', 'yog-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' => __('None', 'yog-core'),
					'1' => __('Image', 'yog-core'),
					'2' => __('Icon', 'yog-core'),

				],
				'condition' => ['show_media' => 'yes']
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __('Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'YOG_PLUGIN_URL' => Utils::get_placeholder_image_src(),
				],
				'condition' => ['show_media' => 'yes']
			]
		);

		

		$this->add_control(
			'selected_icon',
			[
				'label' => __('Icon', 'yog-core'),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'fa-solid',
				],
				'fa4compatibility' => 'icon',
				'separator' => 'before',
				// 'condition' => [
				// 	'image_style' => '2',
				// ],
				'condition' => ['show_media' => 'yes']
			]
		);

		$this->add_control(
			'title_text',
			[
				'label' => __('Number', 'yog-core'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('1000', 'yog-core'),
				'placeholder' => __('Enter your Number', 'yog-core'),
				'label_block' => true,
			]
		);

		 $this->add_control(
			'show_prefix',
			[
				'label' => __( 'Show Prefix', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'yog-core' ),
				'label_off' => __( 'Hide', 'yog-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'counter_prefix',
			[
				'label' => __('Counter Prefix', 'yog-core'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('+', 'yog-core'),
				'placeholder' => __('Enter Prefix', 'yog-core'),
				'label_block' => true,
				'condition' => ['show_prefix' => 'yes']
			]
		);
		$this->add_control(
			'is_active',
			[
				'label' => __( 'active class', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __( 'active', 'yog-core' ),
				'no' => __( 'de-active', 'yog-core' ),
				'return_value' => 'yes',
				// 'default' => 'yes',
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __('Alignment', 'yog-core'),
				'type' => Controls_Manager::CHOOSE,
				'separator' => 'after',
				'default' => 'left',
				'options' => [
					'left' => [
						'title' => __('Left', 'yog-core'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __('Center', 'yog-core'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __('Right', 'yog-core'),
						'icon' => 'eicon-text-align-right',
					],

				],
				'selectors' => [
					'{{WRAPPER}} .gt-counter-contain' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'description_text',
			[
				'label' => __('Content', 'yog-core'),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('Enter your Description here', 'yog-core'),
				'placeholder' => __('Enter your description', 'yog-core'),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Number', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

         $this->start_controls_tabs( 'tabs__WZbRxd5' );
         $this->start_controls_tab(
            'tabs_eCc902a',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_kpscb63',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-counter-contain .timer,.gt-counter-contain .gt-counter-prefix',
			]
		);

 		$this->add_control(
			'title_color__BbYUJF3',
			[
				'label' => __( 'Normal Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-counter-1 .gt-counter-info .timer' => 'color: {{VALUE}};',
					'{{WRAPPER}} .gt-counter-1 .gt-counter-info .gt-counter-num-prefix .gt-counter-prefix' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		

		// Spacing

		
         $this->end_controls_tab();

         $this->start_controls_tab(
            'tabs_Ax450ea',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
		$this->add_control(
			'title_color_s3w1o04',
			[
				'label' => __( 'Hover Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-counter-1:hover .gt-counter-info .timer' => 'color: {{VALUE}};',
					'{{WRAPPER}} .gt-counter-1:hover .gt-counter-info .gt-counter-prefix' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_e38xupd',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-counter-contain .timer:hover,.gt-counter-contain .gt-counter-prefix:hover',
			]
		);
         $this->end_controls_tab();
         $this->end_controls_tabs();
         $this->end_controls_section();
		$this->start_controls_section(
			'section__005e759',
			[
				'label' => __( 'Icon/Image', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section__005e759');

		$this->start_controls_tab(
			'tab_005e759',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_normal_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-counter-1',
			]
		);
		
		$this->add_control(
			'normal_text_color__95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-counter-1 .gt-counter-media i' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_responsive_control(
			'font_size_5128324387',
			[
				'label' => __( 'Icon Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} .gt-counter-contain .gt-counter-media i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab__95c0470',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-counter-1:hover',
			]
		);
		$this->add_control(
			'hover_text_color_95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-counter-1:hover .gt-counter-media i' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

			

		$this->start_controls_section(
			'section_fa4eccc',
			[
				'label' => __( 'Icon Spacing', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->add_responsive_control(
			'padding__72f3Leb',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-media i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__72f3Leb',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-media i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->end_controls_section();

		// Description Style Start
		  $this->start_controls_section(
			'section__74ile76',
			[
				'label' => __( 'Description', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

         $this->start_controls_tabs( 'tabs__74ile76' );
         $this->start_controls_tab(
            'tab_74ile76',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );

         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__74ile76',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-counter-contain .gt-counter-description',
			]
		);

 		$this->add_control(
			'color__74ile76',
			[
				'label' => __( 'Normal Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-counter-1 .gt-counter-info .gt-counter-description' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'has_border__39JtiL9',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__39JtiL9',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__39JtiL9' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-description' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__39JtiL9',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__39JtiL9' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-counter-contain .gt-counter-description' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__39JtiL9',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__39JtiL9' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-description' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__39JtiL9',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__39JtiL9' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-description' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		//Border Style

		// Spacing

		$this->add_responsive_control(
			'padding__39JtiL9',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__39JtiL9',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-counter-contain .gt-counter-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		

		// Spacing

		
         $this->end_controls_tab();

         $this->start_controls_tab(
            'tab_dwL4Svd',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
		$this->add_control(
			'color__dwL4Svd',
			[
				'label' => __( 'Hover Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-counter-1:hover .gt-counter-info .gt-counter-description' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography__dwL4Svd',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-counter-contain .gt-counter-description:hover',
			]
		);
         $this->end_controls_tab();
         $this->end_controls_tabs();        
		 $this->end_controls_section();
		 // Description Style End
	}

	protected function render() {
		$settings = $this->get_settings();
		require YOG_PLUGIN_DIR . '/includes//elementor/render/counter.php';

		if (Plugin::$instance->editor->is_edit_mode()): ?>



		<script>
			 jQuery('.timer').countTo();
		</script>

		<?php endif;
	}

}

Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\yog_counter());