<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class Gt_Contact_Box extends Widget_Base {

	public function get_name() {
		return __( 'myGt_Contact_Box', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Contact Box', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-info-box';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);
		$this->add_control(
            'layout_style',
            [
                
                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/fancybox/1.png', 
                				'2' => YOG_PLUGIN_URL.'/assests/img/fancybox/1.png', 
                				
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );
        $this->end_controls_section();
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Contact Box', 'yog-core' ),
			]
		);
		$this->add_control(
			'image_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'none',
				'options'    => [
					'none'       => __( 'None', 'yog-core' ),
					'1'          => __( 'Image', 'yog-core' ),
					'2'          => __( 'Icon', 'yog-core' ),
					
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				
				'condition' => [
					'image_style' => '1',
				],
			]
		);
		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'fa-solid',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'image_style' => '2',
				]
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is sub sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );
        $this->add_control(
			'title_tag',
			[
				'label' => __( 'Title Tag', 'plugin-domain' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'h5',
				'options' => [
					'h1'  => 'h1',
					'h2'  => 'h2',
					'h3'  => 'h3',
					'h4'  => 'h4',
					'h5'  => 'h5',
					'h6'  => 'h6',
					'p'  => 'p',
					'span'  => 'span',
					
				],
				
			]
			
		);
       $this->add_control(
			'has_desc',
			[
				'label' => __( 'Enable Description?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );
		$this->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter your Description here', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
				'condition' => ['has_desc' => 'yes']
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .gt-contact-box' => 'text-align: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_a820',
			[
				'label' => __( 'Contact Number', 'yog-core' ),
				
			]
		);
		 $this->add_control(
			'phone_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fa fa-phone',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				
			]
		);
		 $this->add_control(
			'number_1',
			[
				'label' => __( 'Number 1', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '+1-541-754-3010', 'yog-core' ),
				
				'label_block' => true,
			]
        );

		 $this->add_control(
			'number_2',
			[
				'label' => __( 'Number 2', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '+1-541-754-3010', 'yog-core' ),
				'label_block' => true,
			]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'section_a820565',
			[
				'label' => __( 'Email', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'email_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fa fa-envelope',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				
			]
		);
		 $this->add_control(
			'email_1',
			[
				'label' => __( 'Email 1', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'info@example.com', 'yog-core' ),
				
				'label_block' => true,
			]
        );

		 $this->add_control(
			'email_2',
			[
				'label' => __( 'Email 2', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'info@example.com', 'yog-core' ),
				
				'label_block' => true,
			]
        );
		$this->end_controls_section();
		 $this->start_controls_section(
			'section_a820g2u8',
			[
				'label' => __( 'Address', 'yog-core' ),
				
			]
		);
		 $this->add_control(
			'address_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fa fa-map-marker',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				
			]
		);
		$this->add_control(
			'address',
			[
				'label' => __( 'Address', 'yog-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter your Address here', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,				
			]
		);
		$this->end_controls_section();
		
		 


		 // Title Style



		 $this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        

         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_kpscb63',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-fancy-box-title',
			]
		);

 		$this->add_control(
			'title_color__BbYUJF3',
			[
				'label' => __( 'TItle Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-title' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'has_border_84609c2',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__d2VjaFs4F4',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border_84609c2' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-fancy-box-title' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__d2VjaAF4',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border_84609c2' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-fancy-box .gt-fancy-box-title' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__d2VjaQF4',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border_84609c2' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-fancy-box-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__d2VjaAF4',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border_84609c2' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-fancy-box-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		

		$this->add_responsive_control(
			'padding__d2VjaGF4',
			[
				'label' => __( 'Padding', 'yog-core' ),
				
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-fancy-box-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__d2VjaF4',
			[
				'label' => __( 'Margin', 'yog-core' ),
				
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-fancy-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		// Spacing

		
        

        
         
         $this->end_controls_section();
        
         // sub titile 

         
         $this->start_controls_section(
			'section__74ile76',
			[
				'label' => __( 'Description', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__74ile7s6',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-fancy-box .gt-Gt_Contact_Box-description',
			]
		);
           $this->add_control(
			'color__74iled76',
			[
				'label' => __( 'Text Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-fancy-box .gt-Gt_Contact_Box-description' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);$this->add_control(
			'has_border__d2VjaF4P',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__d2VjaF4M',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__d2VjaF4P' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-Gt_Contact_Box-description' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__d2VjaF4M',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__d2VjaF4P' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-fancy-box .gt-Gt_Contact_Box-description' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__d2VjaF4M',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF4P' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-Gt_Contact_Box-description' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__d2VjaF4M',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF4P' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-Gt_Contact_Box-description' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		

		$this->add_responsive_control(
			'padding__d2VjaF4M',
			[
				'label' => __( 'Padding', 'yog-core' ),
				
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-Gt_Contact_Box-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__d2VjUaF4M',
			[
				'label' => __( 'Margin', 'yog-core' ),
				
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-fancy-box .gt-Gt_Contact_Box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
  		
		$this->end_controls_tab();
         $this->end_controls_tabs();        
		 $this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/contact-box.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Gt_Contact_Box() );