<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 
class client extends Widget_Base {
	public function get_name() {
		return __( 'client', 'koncpt-core' );
	}
	
	public function get_title() {
		return __( 'client', 'koncpt-core' );
	}
	public function get_categories() {
		return [ 'koncpt-core' ];
    }
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-lock-user';
	}
	protected function _register_controls()
	{
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Client', 'koncpt-core' ),
			]
		);
		$this->add_control(
			'layout_style',
			[
				'label' => __( 'ShoW Style', 'koncpt-core' ),
				'type' => Controls_Manager::SELECT,
				'multiple' => true,
				'default' => 'slider',
				'options' => [
					'slider'  => __( 'Slider', 'koncpt-core' ),
					'grid' => __( 'Grid', 'koncpt-core' ),
					
				],
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __( 'Show Elements', 'koncpt-core' ),
				'type' => Controls_Manager::SELECT,
				'multiple' => true,
				'default' => 'two',
				'options' => [
					'12'  => __( 'One Column', 'koncpt-core' ),
					'6'  => __( 'Two Column', 'koncpt-core' ),
					'4'  => __( 'Three Column', 'koncpt-core' ),
					'3'  => __( 'Four Column', 'koncpt-core' ),
				],
				'condition' => ['layout_style' => 'grid']
			]
		);
		$this->add_control(
			'custom_dimension',
			[
				'label' => __( 'Image Dimension', 'plugin-domain' ),
				'type' => Controls_Manager::IMAGE_DIMENSIONS,
				'description' => __( 'Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'plugin-name' ),
				'default' => [
					'width' => '',
					'height' => '',
				],
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'img_title', [
				'label' => __( 'Title', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'image Title' , 'koncpt-core' ),
				'label_block' => true,
			]
		);
		 
		
		$repeater->add_control(
					'tab_image',
					[
						'label' => __( 'Choose Image 1', 'koncpt-core' ),
						'type' => Controls_Manager::MEDIA,
						'dynamic' => [
		                    'active' => true,
		                    
		                ],                        
		                
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);
		$repeater->add_control(
					'tab_image_1',
					[
						'label' => __( 'Choose Image 2', 'koncpt-core' ),
						'type' => Controls_Manager::MEDIA,
						'dynamic' => [
		                    'active' => true,
		                    
		                ],                           
		                
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);
		$this->add_control(
			'tabs',
			[
				'label' => __( 'Repeater List', 'koncpt-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'img_title' => __( 'Title #1', 'koncpt-core' ),
						'tab_image' => __('get_placeholder_image_src()','koncpt-core')
						// 'tab_image1' => __('get_placeholder_image_src()','koncpt-core')
					],
					
				],
				'title_field' => '{{{ img_title }}}',
			]
		);
		$this->add_control(
			'desk_num',
			[
				'label' => __( 'Desktop number', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '3', 'koncpt-core' ),				
				'separator' => 'before',
				'condition' => ['layout_style' => 'slider']
				
			]
        );
        $this->add_control(
			'lap_num',
			[
				'label' => __( 'Laptop number', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '3', 'koncpt-core' ),				
				'separator' => 'before',
				'condition' => ['layout_style' => 'slider']
				
			]
        );
        $this->add_control(
			'tab_num',
			[
				'label' => __( 'Tablet number', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '2', 'koncpt-core' ),				
				'separator' => 'before',
				'condition' => ['layout_style' => 'slider']
				
			]
        );
        $this->add_control(
			'mob_num',
			[
				'label' => __( 'Mobile number', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '1', 'koncpt-core' ),				
				'separator' => 'before',
				'condition' => ['layout_style' => 'slider']
				
			]
        );
        $this->add_control(
			'autoplay',
			[
				'label'      => __( 'Autoplay', 'koncpt-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'koncpt-core' ),
					'false'          => __( 'False', 'koncpt-core' ),				
					
				],
				'condition' => ['layout_style' => 'slider']
				
			]
		);
		$this->add_control(
			'loop',
			[
				'label'      => __( 'Loop', 'koncpt-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'koncpt-core' ),
					'false'          => __( 'False', 'koncpt-core' ),				
					
				],
				'condition' => ['layout_style' => 'slider']
				
			]
		);
		$this->add_control(
			'nav_arrow',
			[
				'label'      => __( 'Navigation Arrow', 'koncpt-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'koncpt-core' ),
					'false'          => __( 'False', 'koncpt-core' ),				
					
				],
				'condition' => ['layout_style' => 'slider']
				
			]
		);
		$this->add_control(
			'dots',
			[
				'label'      => __( 'Dots', 'koncpt-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'koncpt-core' ),
					'false'          => __( 'False', 'koncpt-core' ),				
					
				],
				'condition' => ['layout_style' => 'slider']
				
			]
		);
		$this->add_responsive_control(
			'margin',
			[
				'label' => __( 'Space', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 30,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => ['layout_style' => 'slider']
				
				
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/client.php';
        if ( Plugin::$instance->editor->is_edit_mode() ) : ?>
		<script>	
		jQuery('.owl-carousel').each(function() {
           var app_slider = jQuery(this);
           app_slider.owlCarousel({
               items: app_slider.data("desk_num"),
               loop: app_slider.data("loop"),
               margin: app_slider.data("margin"),
               nav: app_slider.data("nav"),
               dots: app_slider.data("dots"),
               autoplay: app_slider.data("autoplay"),
               autoplayTimeout: app_slider.data("autoplay-timeout"),
               navText: ["<i class='ion-ios-arrow-back'></i><span>Prev</span>", "<span>Next</span><i class='ion-ios-arrow-forward'></i>"],
               responsiveClass: true,
               responsive: {
                   // breakpoint from 0 up
                   0: {
                       items: app_slider.data("mob_sm"),
                       nav: false,
                       // dots: true
                   },
                   // breakpoint from 480 up
                   480: {
                       items: app_slider.data("mob_num"),
                       nav: false,
                       // dots: true
                   },
                   // breakpoint from 786 up
                   786: {
                       items: app_slider.data("tab_num")
                   },
                   // breakpoint from 1023 up
                   1023: {
                       items: app_slider.data("lap_num")
                   },
                   1199: {
                       items: app_slider.data("desk_num")
                   }
               }
           });
       });
		</script>
		
		<?php endif; 
    }	    
		
}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\client() );