<?php
namespace Elementor;
if (!defined('ABSPATH')) {
	exit;
}

class yog_Circle_progress extends Widget_Base {

	public function get_name() {
		return __('yog_Circle_progress', 'yog-core');
	}

	public function get_title() {
		return __('Circle Progress', 'yog-core');
	}

	public function get_categories() {
		return ['yog-core'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve button widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-loading';
	}

	protected function _register_controls() {

	

		$this->start_controls_section(
			'section_image',
			[
				'label' => __('Progress', 'yog-core'),
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' => __('Title', 'yog-core'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('This is Simple Title', 'yog-core'),
				'placeholder' => __('', 'yog-core'),
				'label_block' => true,
			]
		);

		

		

		$this->add_responsive_control(
			'progress_number',
			[
				'label' => __('Progress Number', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 90,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
			]
		);

		$this->add_responsive_control(
			'progress_size',
			[
				'label' => __('size', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 110,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1024,
					],
				],
			]
		);
		

		$this->add_responsive_control(
			'thickness',
			[
				'label' => __('Thickness', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 12,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
			]
		);

		$this->add_control(
			'fill_color',
			[
				'label' => __('Fill Color', 'yog-core'),
				'type' => Controls_Manager::COLOR,
				

			]
		);
		$this->add_control(
			'empty_color',
			[
				'label' => __('Empty Color', 'yog-core'),
				'type' => Controls_Manager::COLOR,
				

			]
		);
		$this->add_control(
			'pencertage_color',
			[
				'label' => __('Pencertage Color', 'yog-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
								'{{WRAPPER}} .gt-circle-progress .gt-progress-count' => 'color: {{VALUE}};',
					
				],
				

			]
		);
		$this->add_control(
			'Text_color',
			[
				'label' => __('text Color', 'yog-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
								'{{WRAPPER}} .gt-circle-progress .gt-progress-title' => 'color: {{VALUE}};',
					
				],
				

			]
		);



		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		require YOG_PLUGIN_DIR . '/includes/elementor/render/circle-progress.php';

		if (Plugin::$instance->editor->is_edit_mode()): ?>



			<script>
				 jQuery('.gt-circle-progress-bar').each(function() {
      var number = jQuery(this).data('skill-level');
      var empty_color = jQuery(this).data('empty-color');
      var fill_color = jQuery(this).data('fill-color');
      var size = jQuery(this).data('size');
      
       jQuery(this).circleProgress({
      value: '0.' + number,
      size: size,
      emptyFill: empty_color,
      fill: {
        color: fill_color
      }
    }).on('circle-animation-progress', function(event, progress) {
      jQuery(this).find('.gt-progress-count').html(Math.round(number * progress) + '%');
    });

       });
			</script>

		<?php endif;
	}

}

Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\yog_Circle_progress());