<?php

namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) exit; 



class Button extends Widget_Base {



	public function get_name() {

		return __( 'Button', 'yog-core' );

	}

	

	public function get_title() {

		return __( 'Button', 'yog-core' );

	}



	public function get_categories() {

		return [ 'yog-core' ];

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve counter widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-button';

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_Jnza43wt8d9QH5b77duo',

			[

				'label' => __( 'gym Button', 'yog-core' ),

			]

		);

			require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_controls.php';



		//$this->end_controls_section();

	}

	

	protected function render() {

		$settings = $this->get_settings();

        require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';

    }	    

		

}



Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Button() );