<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) )
{
  exit;
}
$settings = $this->get_settings();
// $hide = (bool) ($settings['blog_hides']);
$align = $settings['text_align'];

$this->add_render_attribute( 'btn_attr', 'class', 'gt-button' );
if($settings['btn_style'] == 'btn-flat')
{

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-flat' );
}
if($settings['btn_style'] == 'btn-outline')
{

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-outline' );
}
if($settings['btn_style'] == 'btn-link')
{

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-link' );
}
   global $paged;
  if (empty($paged)) {
  $paged = 1;
  }
  $args = array(
  'post_type'         => 'post',
  'post_status'       => 'publish',
  'suppress_filters'  => 0,
  'paged' => $paged
  );
  $posts = new \WP_Query($args);

    $pagination_args = array(
    //'base'            => get_pagenum_link(1) . '%_%',
    'format'      => '?paged=%#%',
    'total'           => $posts->max_num_pages,
    'current'         => $paged,
    'show_all'        => False,
    'end_size'        => 1,
    'mid_size'        => 2,
    'prev_next'       => True,
    'prev_text'       =>  esc_html__( 'Previous page', 'yog-core' ),
    'next_text'       => esc_html__( 'Next page', 'yog-core' ),
    'type'            => 'list',
    'add_args'        => false,
    'add_fragment'    => ''
    );
   $paginate_links = paginate_links($pagination_args);
    if($settings['blog_style'] === "1")
    {
        $col = 'col-lg-12';
        $grid = 'gt-blog-col-1';
    }
    if($settings['blog_style'] === "2")
    {
        $col = 'col-lg-6';
        $grid = 'gt-blog-col-2';
    }
    if($settings['blog_style'] === "3")
    {
        $col = 'col-lg-4';
        $grid = 'gt-blog-col-3';
    }
  ?>
<div class="gt-blog <?php echo esc_attr($grid); ?>">
  <div class="row">

    <?php
      if ( $posts -> have_posts() )
      {
      while ( $posts -> have_posts() )
      {
        $posts->the_post();

        // $image_PEACEFULQODE_PLUGIN_URL = Group_Control_Image_Size::get_attachment_image_src( get_post_thumbnail_id( $posts->ID ), 'thumbnail', $settings );
      ?>
          <div class="<?php echo esc_attr__($col,'yog-core'); ?>">
           <div class="gt-blog-post">
              <div class="gt-post-media">
                 <?php  the_post_thumbnail(); ?>
              </div>
              <?php
                 $archive_year  = get_the_time( 'Y' );
                 $archive_month = get_the_time( 'm' );
                 $archive_day   = get_the_time( 'd' );
                 ?>
              <div class="gt-blog-contain">
                 <?php if(has_post_thumbnail()){ ?>
                 <div class="gt-post-date">
                    <a href="<?php echo esc_url( get_day_link($archive_year, $archive_month, $archive_day ) ); ?>">
                    <span><?php echo esc_html( get_the_date()); ?></span></a>
                 </div>
                 <?php } ?>
                 <div class="gt-post-meta">
                    <ul>
                       <li class="pt-post-author"><i class="fa fa-user"></i><?php the_author(); ?></li>

                       <li class="pt-post-tag">
                             <?php
                                $i =0;
                                $categories = get_the_category( get_the_ID() );
                                foreach( $categories as $category ) {
                                  if($i==0)
                                  {
                                  ?>
                                 <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><i class="fa fa-tag"></i><?php echo esc_attr( $category->name ) ?></a>
                                  <?php
                                  $i++;
                                }}
                            ?>
                            </li>
                    </ul>
                 </div>
                 <h5 class="gt-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                 
                 <div class="gt-blog-info">
                    <?php if ($settings['des_button'] == 'yes') {

                           the_excerpt();

                            }  ?>
                 </div>
                 <div class="gt-btn-container">
                    <div class="gt-button-block">
                       <a href="<?php echo the_permalink(); ?>" <?php echo $this->get_render_attribute_string('btn_attr'); ?>> <span><?php echo esc_html($settings['button_text']); ?></span></a>
                    </div>
                 </div>
              </div>
           </div>
          </div>

    <?php
      }
      if ($paginate_links) {

        echo '<div class="col-lg-12 col-md-12 col-sm-12">
          <div class="gt-pagination">
              <nav aria-label="Page navigation">';
              printf( esc_html__('%s','yog-core'),$paginate_links);
              echo '</nav>
            </div>
          </div>';
    }

      }
      wp_reset_query();

      ?>
  </div>
</div>