<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) )

{

  exit;

}

$settings = $this->get_settings();

// $hide = (bool) ($settings['blog_hides']);

$align = $settings['text_align'];





 $this->add_render_attribute( 'btn_attr', 'class', 'gt-button' );

if($settings['btn_style'] == 'btn-flat')

{



  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-flat' );

}



if($settings['btn_style'] == 'btn-outline')

{



  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-outline' );

}



if($settings['btn_style'] == 'btn-link')

{



  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-link' );

}

      global $paged;

      if (empty($paged))

      {

        $paged = 1;

      }

      $args = array(

      'post_type'         => 'post',

      'post_status'       => 'publish',

      'suppress_filters'  => 0,

      'paged' => $paged

      );

      $posts = new \WP_Query($args);

      $this->add_render_attribute('slider', 'data-dots', $settings['dots']);

      $this->add_render_attribute('slider', 'data-nav', $settings['nav_arrow']);

      $this->add_render_attribute('slider', 'data-desk_num', $settings['desk_num']);

      $this->add_render_attribute('slider', 'data-lap_num', $settings['lap_num']);

      $this->add_render_attribute('slider', 'data-tab_num', $settings['tab_num']);

      $this->add_render_attribute('slider', 'data-mob_num', $settings['mob_num']);

      $this->add_render_attribute('slider', 'data-mob_sm', $settings['mob_num']);

      $this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);

      $this->add_render_attribute('slider', 'data-loop', $settings['loop']);

      $this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);

  ?>

<div class="gt-blog text-<?php echo esc_attr($align,'yog-core'); ?>">

  <div class="owl-carousel" <?php echo $this->get_render_attribute_string('slider'); ?>>

    <?php

      if ( $posts -> have_posts() )

      {

          while ( $posts -> have_posts() )

          {

            $posts->the_post();

          ?>

            <div class="item">

               <div class="gt-blog-post">

                  <div class="gt-post-media">

                     <?php  the_post_thumbnail(); ?>

                  </div>

                  <?php

                     $archive_year  = get_the_time( 'Y' );

                     $archive_month = get_the_time( 'm' );

                     $archive_day   = get_the_time( 'd' );

                     ?>

                  <div class="gt-blog-contain">



                    <?php if(has_post_thumbnail()){ ?>

                     <div class="gt-post-date">

                        <a href="<?php echo esc_url( get_day_link($archive_year, $archive_month, $archive_day ) ); ?>">

                        <span><?php echo esc_html( get_the_date()); ?></span></a>

                     </div>

                    <?php } ?>

                    <div class="gt-post-meta">

                        <ul>
                           <li class="pt-post-author"><i class="fa fa-user"></i><?php the_author(); ?></li>

                           <li class="pt-post-tag">

                             <?php

                                $i =0;

                                $categories = get_the_category( get_the_ID() );

                                foreach( $categories as $category ) {

                                  if($i==0)

                                  {

                                  ?>

                                 <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><i class="fa fa-tag"></i><?php echo esc_attr( $category->name ) ?></a>

                                  <?php

                                  $i++;

                                }}

                            ?>

                            </li>


                        </ul>

                     </div>

                     <h5 class="gt-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

                     <?php if ($settings['des_button'] == 'yes') { ?>
                     <div class="gt-blog-info">

                      <?php   the_excerpt(); ?>
                     </div>
                   <?php } ?>

                     <div class="gt-btn-container">

                        <div class="gt-button-block">

                           <a href="<?php echo the_permalink(); ?>" <?php echo $this->get_render_attribute_string('btn_attr'); ?>> <span><?php echo esc_html($settings['button_text']); ?></span></a>

                        </div>

                     </div>

                  </div>

               </div>

            </div>



          <?php

          }

           wp_reset_query();

      }



      ?>

  </div>

</div>

