<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class blogers extends Widget_Base {

	public function get_name() {
		return __( 'blog', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Blog', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
    }
    
	

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'Blog', 'yog-core' ),
			]
		);

		 

		$this->add_control(
			'blog_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => '0',
				'options'    => [
					'0'       => __( 'slider', 'yog-core' ),
					'1'          => __( '1 Column', 'yog-core' ),
					'2'          => __( '2 Column', 'yog-core' ),
					'3'          => __( '3 Column', 'yog-core' ),
					
				],
			]
		);


		$this->add_control(
			'blog_hides',
			[
				'label' => __( 'hide description', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
				'condition' => [
					'blog_style' => '0',
				]
			]
        );

		$this->add_control(
			'desk_num',
			[
				'label' => __( 'Desktop number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '3', 'yog-core' ),				
				'separator' => 'before',
				'condition' => [
					'blog_style' => '0',
				]
			]
        );
        $this->add_control(
			'lap_num',
			[
				'label' => __( 'Laptop number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '3', 'yog-core' ),				
				'separator' => 'before',
				'condition' => [
					'blog_style' => '0',
				]
			]
        );

        $this->add_control(
			'tab_num',
			[
				'label' => __( 'Tablet number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '2', 'yog-core' ),				
				'separator' => 'before',
				'condition' => [
					'blog_style' => '0',
				]
			]
        );

        $this->add_control(
			'mob_num',
			[
				'label' => __( 'Mobile number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '1', 'yog-core' ),				
				'separator' => 'before',
				'condition' => [
					'blog_style' => '0',
				]
			]
        );

        $this->add_control(
			'autoplay',
			[
				'label'      => __( 'Autoplay', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'false'          => __( 'False', 'yog-core' ),				
					
				],
				'condition' => [
					'blog_style' => '0',
				]
			]
		);
		$this->add_control(
			'loop',
			[
				'label'      => __( 'Loop', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'false'          => __( 'False', 'yog-core' ),				
					
				],
				'condition' => [
					'blog_style' => '0',
				]
			]
		);

		$this->add_control(
			'nav_arrow',
			[
				'label'      => __( 'Navigation Arrow', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'false'          => __( 'False', 'yog-core' ),				
					
				],
				'condition' => [
					'blog_style' => '0',
				]
			]
		);
		$this->add_control(
			'dots',
			[
				'label'      => __( 'Dots', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'false'          => __( 'False', 'yog-core' ),				
					
				],
				'condition' => [
					'blog_style' => '0',
				]
			]
		);

		$this->add_responsive_control(
			'margin',
			[
				'label' => __( 'Space', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 30,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'blog_style' => '0',
				]
				
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', 
				'default' => 'full',
				'separator' => 'none'				
			]
			
		);    

		 
        $this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'after',
                'default' => __( 'left', 'yog-core' ),
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				]
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'section_Jnza43wt8d9QH5b77duo',
			[
				'label' => __( 'Blog Button', 'yog-core' ),
			]
		);
			$this->add_control(
			'button_text',
			[
				'label' => __( 'Button Text', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Read More', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );
        

       
		$this->end_controls_section();

		


	
		// Button Style Section
		$this->start_controls_section(
			'section_y8ubBfbAH1e2VwpN5be9',
			[
				'label' => __( 'Button Style', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);

		$this->add_control(
            'btn_style',
            [   
                'type' => 'image_select_control',
                'option' => [
                				'btn-flat' => 'https://via.placeholder.com/200x80.png?text=btn-flat', 
                				'btn-outline' => 'https://via.placeholder.com/200x80.png?text=btn-outline', 
                				'btn-link' => 'https://via.placeholder.com/200x80.png?text=btn-link', 
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );
        $this->add_responsive_control(
			'margin__4801777',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
			$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'plugin-domain' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .gt-button-block .gt-button span',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .gt-button span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => __( 'Background Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color11',
			[
				'label' => __( 'Background Line Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button .gt-button-line-left' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button span:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label' => __( 'Background Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_background_hover_color1',
			[
				'label' => __( 'Background Line Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button:hover .gt-button-line-left' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();// Button Size Section

		//$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require_once YOG_PLUGIN_DIR . '/includes/elementor/render/blog.php';

         if ( Plugin::$instance->editor->is_edit_mode() ) : ?>



		<script>	
		jQuery('.owl-carousel').each(function() {
           var app_slider = jQuery(this);
          
          
           
           app_slider.owlCarousel({
               items: app_slider.data("desk_num"),
               loop: app_slider.data("loop"),
               margin: app_slider.data("margin"),
               nav: app_slider.data("nav"),
               dots: app_slider.data("dots"),
               autoplay: app_slider.data("autoplay"),
               autoplayTimeout: app_slider.data("autoplay-timeout"),
               navText: ["<i class='ion-ios-arrow-back'></i><span>Prev</span>", "<span>Next</span><i class='ion-ios-arrow-forward'></i>"],
               responsiveClass: true,
               responsive: {
                   // breakpoint from 0 up
                   0: {
                       items: app_slider.data("mob_sm"),
                       nav: false,
                   },
                   // breakpoint from 480 up
                   480: {
                       items: app_slider.data("mob_num"),
                       nav: false,
                   },
                   // breakpoint from 786 up
                   767: {
                       items: app_slider.data("tab_num")
                   },
                   // breakpoint from 1023 up
                   1023: {
                       items: app_slider.data("lap_num")
                   },
                   1199: {
                       items: app_slider.data("desk_num")
                   }
               }
           });
       });
		</script>
		
		<?php endif; 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\blogers() );