<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class Banner extends Widget_Base {

	public function get_name() {
		return __( 'banner', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Banner Content', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-banner';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Banner', 'yog-core' ),
			]
		);

		

		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title & Description', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is newt_textbox_set_height(textbox, height) heading', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'none',
				'rows' => 10,
				'show_label' => false,
			]
		);

		

		

		$this->add_control(
			'view',
			[
				'label' => __( 'View', 'yog-core' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'YOG_PLUGIN_URL' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', 
				'default' => 'full',
				'separator' => 'none',
			]
		);

		
		

		

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				]
			]
		);


		$this->add_control(
			'text',
			[
				'label' => __( 'Normal Button', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Click here', 'yog-core' ),
				'placeholder' => __( 'Click here', 'yog-core' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'yog-core' ),
				'type' => Controls_Manager::YOG_PLUGIN_URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'yog-core' ),
				'default' => [
					'YOG_PLUGIN_URL' => '#',
				],
			]
		);

		$this->add_control(
			'video_text',
			[
				'label' => __( 'Video Button', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Click here', 'yog-core' ),
				'placeholder' => __( 'Click here', 'yog-core' ),
			]
		);

		$this->add_control(
			'video_link',
			[
				'label' => __( 'Link', 'yog-core' ),
				'type' => Controls_Manager::YOG_PLUGIN_URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'yog-core' ),
				'default' => [
					'YOG_PLUGIN_URL' => '#',
				],
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Video Button Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'fa-solid',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before'
			]
		);

		

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/banner.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Banner() );