<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Accordion extends Widget_Base {

	public function get_name() {
		return __( 'yog_core_accordion', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Accordion', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-accordion';
	}

	
	public function get_script_depends() {
		return [ 'yog-core-custom' ];
	 }

	protected function _register_controls() {
		
        
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Accordion', 'yog-core' ),
			]
		);

        
        
        $repeater = new Repeater();
        $repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Question', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'What is Lorem Ipsum?', 'yog-core' ),
				'placeholder' => __( 'Tab Title', 'yog-core' ),
				'label_block' => true,
			]
        );
        
        $repeater->add_control(
			'tab_content',
			[
				'label' => __( 'Answer', 'yog-core' ),
				'default' => __( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'yog-core' ),
				'placeholder' => __( 'Tab Content', 'yog-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => false,
			]
        );
        

        
        $this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'Tab #1', 'yog-core' ),
                        'tab_content' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'yog-core' ),
                       
					]
					
				],
				'title_field' => '{{{ tab_title }}}',
			]
        );
        $this->add_control(
			'has_icon',
			[
				'label' => __( 'Use Icon?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
		);
		
		$this->add_control(
			'yog-core_has_box_shadow',
			[
				'label' => __( 'Box Shaow?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );
        
        $this->add_control(
			'active_icon',
			[
				'label' => __( 'Active Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'ion ion-ios-arrow-down'
					
				],
				'condition' => [
					'has_icon' => 'yes',
				],
				'label_block' => false,
				'skin' => 'inline',

				
			]
		);
		$this->add_control(
			'inactive_icon',
			[
				'label' => __( 'Inactive Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'ion ion-ios-arrow-up'
					
				],
				'condition' => [
					'has_icon' => 'yes',
				],
				'label_block' => false,
				'skin' => 'inline',

				
			]
		);
		$this->add_responsive_control(
			'icon_position',
			[
				'label' => __( 'Icon Position', 'yog-core' ),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'right',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],
					
                ],
                'condition' => [
					'has_icon' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __( 'Title Tag', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'h4',
				'options'    => [
					
					'h1'          => __( 'h1', 'yog-core' ),
					'h2'          => __( 'h2', 'yog-core' ),
					'h3'          => __( 'h3', 'yog-core' ),
					'h4'          => __( 'h4', 'yog-core' ),
					'h5'          => __( 'h5', 'yog-core' ),
					'h6'          => __( 'h6', 'yog-core' ),
					
					
				],
			]
		);



		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],
					'text-justify' => [
						'title' => __( 'Justified', 'yog-core' ),
						'icon' => 'eicon-text-align-justify',
					],
				]
			]
		);	

        $this->end_controls_section();

        

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => __( 'Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'tabs_2a0sGfU' );
         $this->start_controls_tab(
            'tabs_tJ784N2F',
            [
                'label' => __( 'Text Color', 'elementor' ),
            ]
        );
         $this->add_control(
			'title_colors',
			[
				'label' => __( 'Text Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-title .accordion-title' => 'color: {{VALUE}};',
					
				],
			]
		);

		$this->add_control(
			'title_active_color',
			[
				'label' => __( 'Text Active Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-active .gt-accordion-title .accordion-title' => 'color: {{VALUE}};',
					
				],
			]
		);
		$this->end_controls_tab();

        $this->start_controls_tab(
            'tabs__Ax450e0a',
            [
                'label' => __( 'background Color', 'elementor' ),
            ]
        );
        $this->add_control(
			'title_back_color',
			[
				'label' => __( 'Background Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-title' => 'background: {{VALUE}};',
					
				],
			]
		);

		$this->add_control(
			'title_back_active_color',
			[
				'label' => __( 'Active Background Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-active .gt-accordion-title' => 'background: {{VALUE}};',
					
				],
			]
		);
        
         $this->end_controls_tab();
         $this->end_controls_tabs();		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Content', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Content Text Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-ad-title' => 'color: {{VALUE}};',
					
				],
			]
		);

		$this->add_control(
			'content_back_color',
			[
				'label' => __( 'Background Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-ad-title' => 'background: {{VALUE}};',
					
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'icon_active_color',
			[
				'label' => __( 'Active Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-box.gt-active .gt-accordion-title i.active' => 'color: {{VALUE}};',
					
				],
			]
		);

		$this->add_control(
			'icon_inactive_color',
			[
				'label' => __( 'Inactive Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-box .gt-accordion-title i.inactive' => 'color: {{VALUE}};',
					
				],
			]
		);
		$this->add_responsive_control(
			'font_size_21Bupaqvc',
			[
				'label' => __( 'Font Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} .' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_border_style',
			[
				'label' => __( 'Border', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'has_border',
			[
				'label' => __( 'Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'label_off',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );
        $this->add_control(
			'border_style',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'none',
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					'condition' => [
					'has_border' => 'yes',
					],
					'selectors' => [
						'{{WRAPPER}} .gt-accordion .gt-accordion-box' => 'border-style: {{VALUE}};',
						
					],
				]
			);

		$this->add_control(
			'border_active_color',
			[
				'label' => __( 'Active Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-box.gt-active' => 'border-color: {{VALUE}};',
					
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'border_inactive_color',
			[
				'label' => __( 'Inactive Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-box' => 'border-color: {{VALUE}};',
					
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);

		
		$this->add_control(
			'border_width',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .gt-accordion .gt-accordion-box' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);
		$this->add_control(
			'border_radius_Pa756UR',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-section-title-box .gt-section-sub-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->add_responsive_control(
			'margin_21Bupac',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'condition' => [
					'has_border' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-section-title-box .gt-section-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->add_responsive_control(
			'padding_21Bupac',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'condition' => [
					'has_border' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-section-title-box .gt-section-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);


		$this->end_controls_section();
		//$this->end_controls_section();

        


	}
	
	protected function render() {
		$settings = $this->get_settings();
        require  YOG_PLUGIN_DIR . '/includes/elementor/render/accordin.php';

        ?>
        	<script type="text/javascript">
        		 /*------------------------
                Accordion
                --------------------------*/
                jQuery('.gt-accordion-block .gt-accordion-box .gt-accordion-details').hide();
                jQuery('.gt-accordion-block .gt-accordion-box:first').addClass('gt-active').children().slideDown('slow');
                jQuery('.gt-accordion-block .gt-accordion-box').on("click", function() {
                    if (jQuery(this).children('div.gt-accordion-details').is(':hidden')) {
                        jQuery('.gt-accordion-block .gt-accordion-box').removeClass('gt-active').children('div.gt-accordion-details').slideUp('slow');
                        jQuery(this).toggleClass('gt-active').children('div.gt-accordion-details').slideDown('slow');
                    }
                });

                

        	</script>
        <?php 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Accordion() );