<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 
class marquee extends Widget_Base {
	public function get_name() {
		return __( 'marquee', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'marquee', 'yog-core' );
	}
	public function get_categories() {
		return [ 'yog-core' ];
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Image Box', 'yog-core' ),
			]
		);
	$repeater = new Repeater();
		$repeater->add_control(
			'image_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'none',
				'options'    => [
					'none'       => __( 'None', 'yog-core' ),
					'1'          => __( 'Image', 'yog-core' ),
					'2'          => __( 'Icon', 'yog-core' ),
					
				],
			]
		);
		
		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				
				'condition' => [
					'image_style' => '1',
				],
			]
		);
		
		
		$repeater->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-android-arrow-dropright',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'image_style' => '2',
				]
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title_text' => __( 'Service Box', 'yog-core' ),
						
						
					]
				]
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/marquee.php';
		
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\marquee() );