<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 


$settings = $this->get_settings();
$html = '';

$tabs = $this->get_settings_for_display( 'tabs' );
$lists = $this->get_settings_for_display( 'list' );

$align = $settings['text_align'];

$title_html = $settings['button_text'];


$this->add_render_attribute( 'btn_attr', 'class', 'gt-button' ); 


if($settings['btn_style'] == 'btn-flat')
{
  
  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-flat' ); 
}

if($settings['btn_style'] == 'btn-outline')
{
  
  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-outline' ); 
}

if($settings['btn_style'] == 'btn-link')
{
  
  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-link' ); 
}

$html .='<div class="gt-tabs-1">
			<div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">'; 
foreach ( $tabs as $index => $item )
{
	

	if($index == 0)
	{
		$class = "active";
	}
	else
	{
		$class = "";
	}

   $html .= sprintf('<a class="gt-tabs nav-item nav-link '.esc_attr($class).'" 
							   id="nav-home-'.$index.'" data-toggle="tab" 
							   href="#'.esc_attr('nav-'.$index).'" 
							   role="tab" aria-controls="nav-home-'.$index.'" 
							   aria-selected="true"><div class = "gt-tabs-icon"><i class="%2$s"></i><span>%1$s</span></div></a>',esc_html($item['tab_title']),esc_attr($item['selected_icon']['value']));

}


$html .= '</div>';
$html .= '<div class="tab-content text-'.esc_attr($align).'" id="nav-tabContent">';


$image_html ='';

foreach ( $tabs as $index => $item ){
	$row = 'row';
	if ( ! empty( $item['image']['url'] ) ) {
		$image_html = sprintf('<img src="%1$s" alt="seo-image"/>',esc_url($item['image']['url']));
	}
	if($index == 0)
	{
		$class = "active";
	}
	else
	{
		$class = "";
	}
	if($index%2 != 0)
	{
		$row = 'row flex-row-reverse';
	}

	if ( ! empty( $item['tab_btn_link']['url'] ) ) 
	{
	    $this->add_render_attribute( 'btn_attr'.$index, 'href', $item['tab_btn_link']['url'] );

	    if ( $item['tab_btn_link']['is_external'] ) {
	        $this->add_render_attribute( 'btn_attr'.$index, 'target', '_blank' );
	    }

	    if ( ! empty( $item['tab_btn_link']['nofollow'] ) ) {
	        $this->add_render_attribute( 'btn_attr'.$index, 'rel', 'nofollow' );
	    }
	}

	$html .= '<div class="tab-pane fade show  '.esc_attr($class).'" id="'.esc_attr('nav-'.$index).'" role="tabpanel" aria-labelledby="nav-home-'.$index.'">
				<div class="'.esc_attr($row).'">
					<div class="col-lg-6">
						'.$image_html.'
					</div>
					<div class="col-lg-6">
						<div class="gt-tab-info">
							<h2>'.esc_html($item['title_text']).'</h2>
							<p>'.esc_html($item['description_text']).'</p>';
							if(!empty($item['list']))
							{
								$html .= $this->parse_text_editor($item['list']);	
							}
							$html .= '<div class="gt-btn-container">
						    <div class="gt-button-block">
									<a '.$this->get_render_attribute_string('btn_attr').' '.$this->get_render_attribute_string('btn_attr'.$index).'>
						        <span class="gt-button-line-left"></span>
									<span class="text">'.esc_html($settings['button_text']).'</span>
						            <span class="gt-button-line-right"></span>
									</a>
						    </div>  

						</div>';
						$html.='</div>
					</div>
				</div>			
					
  			  </div>';
  			  $image_html ='';

}

$html .= '</div></div>';
echo $html;
