<?php
namespace Elementor;
if (!defined('ABSPATH')) {
 exit;
}
//$this->add_render_attribute( 'list_item', 'class', 'elementor-icon-list-item' );
$settings   = $this->get_settings();
$options = get_option('theme_options');

$image_html = "";
if ($settings['image_style'] === "1") {
    if (!empty($settings['image']['url'])) {
        $image_html = '<div class="pt-sub-media"><img src="'.esc_url($settings['image']['url']).'" alt="'.esc_attr(__('subscribe' , 'enerzy-core')).'" />';
        $image_html .= '</div>';
    }
}
if ($settings['image_style'] === "2") {
    if (!empty($settings['selected_icon']['value'])) {
        $this->add_render_attribute('selected_icon', 'class', esc_attr($settings['selected_icon']['value']));
        $image_html .= '<div class="pt-sub-media">';
        $image_html .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('selected_icon'));
        $image_html .= '</div>';
    }
}
?>
<div class="pt-subscribe align-items-center">
	<div class="container">
		<div class="row">
			<div class="col-lg-6">
				<div class="pt-subscribe-block">
					<?php echo $image_html; ?>
					<div class="pt-subscribe-details">
						<h6 class="pt-subscribe-title">
							<?php
							if(!empty($settings['title_text']))
							{
								echo esc_html($settings['title_text']);
							}
							?>
						</h6>
						<span class="pt-subscribe-desc">
							<?php
							if(isset($settings['description_text']))
							{
								echo esc_html($settings['description_text']);
							}
							?>
							</span>
					</div>
				</div>
			</div>
			<div class="col-lg-6">
				<div class="pt-subscribe-from">
					<?php echo do_shortcode($options['yog_subscribe_shortcode']); ?>
				</div>
			</div>
		</div>
	</div>
</div>