<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
}

$html = '';

$settings = $this->get_settings();
//$settings = $this->get_settings_for_display();


$title_html = $settings['title_text'];

$image_html = "";
if ($settings['image_style'] === "1") {
    if (!empty($settings['image']['url'])) {
        $image_html = '<div class="gt-service-media"><i><img src="'.esc_url($settings['image']['url']).'" alt="'.esc_attr(__('servicebox' , 'yog-core')).'" /></i></div>';

    }
}

if ($settings['image_style'] === "2") {
    if (!empty($settings['selected_icon']['value'])) {
        $this->add_render_attribute('selected_icon', 'class', esc_attr($settings['selected_icon']['value']));
        $image_html .= '<div class="gt-service-media">';
        $image_html .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('selected_icon'));
        $image_html .= '</div>';
    }

}

if (!empty($settings['title_text'])) {
    $title_html = $settings['title_text'];
} else {
    $title_html = "This is sample title";
}

if (!empty($settings['description_text'])) {
    $desc_html = $this->parse_text_editor($settings['description_text']);
} else {
    $desc_html = "Lorem Ipsum is simply dummy text of the printing and typesetting yog_.";
}

if (!empty($settings['sub_title_text'])) {
    $sub_title = $settings['sub_title_text'];
} else {
    $sub_title = "Simple Sub Title";
}


$title = sprintf('<%1$s class="gt-service-title">%2$s</%1$s>', $settings['title_tag'],$title_html);


 $banner = '<div class="gt-service-banner"><img src="'.esc_url($settings['banner_image']['url']).'" alt="'.esc_attr(__('servicebox' , 'yog-core')).'" />
 '.$image_html.'
 </div>';


if ($settings['service_style'] === "1") {
    ?>
<div class="gt-service-box gt-service-box-1">
    <?php echo $banner; ?>
    <div class="gt-service-box-info">
        <?php echo $title; ?>
       
        
        <p class="gt-service-description"><?php echo $desc_html; ?></p> 

        
           <?php 
            require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';
           ?>
        

    </div>
</div>

<?php
}