<?php

namespace Elementor;

if (!defined('ABSPATH')) {

	exit;

}

$html = '';

$settings = $this->get_settings();

$title_html = $settings['title_text'];

$lists = $this->get_settings_for_display( 'list' );

$star = $settings['star'];

$image_html = "";

$icon_html = "";

if ($settings['image_style'] === "1") {

    if (!empty($settings['image']['url'])) {

        $image_html = '<div class="gt-service-media"><i><img src="'.esc_url($settings['image']['url']).'" class="img-fluid" alt="'.esc_attr(__('servicebox' , 'yog-core')).'" /></i></div>';

    }

}

if ($settings['image_style'] === "2") {

    if (!empty($settings['selected_icon']['value'])) {

        $this->add_render_attribute('selected_icon', 'class', esc_attr($settings['selected_icon']['value']));

        $image_html .= '<div class="gt-service-media">';

        $image_html .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('selected_icon'));

        $image_html .= '</div>';

    }

}



if (!empty($settings['title_text'])) {

	$title_html = $settings['title_text'];

} else {

	$title_html = "This is sample title";

}

if (!empty($settings['sub_title_text'])) 

{

	$sub_title = $settings['sub_title_text'];

} 

else

{

	$sub_title = "Simple Sub Title";

}

if (!empty($settings['description_text'])) {

	$desc_html = $this->parse_text_editor($settings['description_text']);

} else {

	$desc_html = "Lorem Ipsum is simply dummy text of the printing and typesetting yog_.";

}

$title = sprintf('<%2$s class="gt-service-title"><a href="%3$s">%1$s</a></%2$s>',$title_html,$settings['title_tag'] , "#");

// $sub_tit = sprintf('<span class="gt-service-sub-title">%1$s</span>',$sub_title_text);

$banner = '<div class="gt-service-img"><img src="'.esc_url($settings['banner_image']['url']).'" alt="'.esc_attr(__('servicebox' , 'yog-core')).'" />

'.$image_html.'

</div>';

if ($settings['service_style'] === "1")

{

	?>

	<div class="gt-service-box gt-service-box-1">

		<?php echo $banner; ?>

		  

		  <?php
				  foreach ( $lists as $index => $item ){
				    $icon =  esc_attr($item['select_icon']['value']);
				    
				    $list_title = esc_html($item['list_title']);
				   
				   
				    
				    ?>
				    <div class="gt-service-hover-contain">
                      <div class="gt-service-list">
				        
				      <div class="gt-post-list">
				         <div class="gt-post-list-icon">
				         <i class="<?php echo $icon; ?>"></i>
				       </div>
				        <div class="gt-contain-list">
                        	  <?php echo $list_title;?>
                        </div>

				    </div>
				     </div>
				   </div>
				   <?php
				}
				?>
        
      <div class="gt-service-info">

      <?php echo $image_html;?>

      <div class="gt-sub-title">
                     <?php echo esc_html($settings['subtitle_text']);?>        
                  </div>

      <?php echo $title; ?>

    
            <div class="gt-service-meta">
             
              <div class="gt-service-price">
                <span> <?php echo esc_html($settings['price']);?> </span>
              
             </div>
             
                    <div class="gt-service-star">
                    <?php
                    for($i=1;$i<=$star;$i++)
                    { 
                    ?>
                   <i class="fa fa-star"></i>
                   <?php } ?>
                 </div>
         </div>
       
      <?php if ($settings['show_button'] == 'yes') {

      require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';
      } 

      ?>

    </div>
		 

	</div>

	<?php

}

if ($settings['service_style'] === "2")

{

	?>

	<div class="gt-service-box gt-service-box-2">

		<?php echo $banner; ?>

		
        <div class="gt-service-info">

			<?php echo $title; ?>

			<p class="gt-service-description"><?php echo $desc_html; ?> 

			<?php 

			require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';

			?>

		</div>

	</div>

	<?php

}

if ($settings['service_style'] === "3")

{

	?>

	<div class="gt-service-box gt-service-box-3">

		<?php echo $banner; ?>

		<?php echo $icon_html; ?>

		<div class="gt-service-box-info">

			<?php echo $title; ?>

			<p class="gt-service-description"><?php echo $desc_html; ?> 

			<?php 

			require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';

			?>

		</div>

	</div>

	<?php

}

if ($settings['service_style'] === "4")

{

	?>

	<div class="gt-service-box gt-service-box-4">

		<?php echo $banner; ?>

		

		<div class="gt-service-box-info">

			<div class="gt-service-media">

		    <i class="<?php echo esc_attr($settings['selected_icon']['value']) ?>">

		    </i></div>

			<?php echo $title; ?>

			<p class="gt-service-description"><?php echo $desc_html; ?> </p>

			

		</div>

	</div>

	<?php

}

