<?php

namespace Elementor;

if (!defined('ABSPATH')) {

    exit;

}

$html = '';

$settings = $this->get_settings();

$tabs = $this->get_settings_for_display( 'tabs' );

$this->add_render_attribute('slider', 'data-dots', $settings['dots']);

$this->add_render_attribute('slider', 'data-nav', $settings['nav_arrow']);

$this->add_render_attribute('slider', 'data-desk_num', $settings['desk_num']);

$this->add_render_attribute('slider', 'data-lap_num', $settings['lap_num']);

$this->add_render_attribute('slider', 'data-tab_num', $settings['tab_num']);

$this->add_render_attribute('slider', 'data-mob_num', $settings['mob_num']);

$this->add_render_attribute('slider', 'data-mob_sm', $settings['mob_num']);

$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);

$this->add_render_attribute('slider', 'data-loop', $settings['loop']);

$this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);

$this->add_render_attribute( 'btn_attr', 'class', 'gt-button' ); 

// if ( ! empty( $settings['btn_link']['url'] ) ) 

// {

//     $this->add_render_attribute( 'btn_attr', 'href', $settings['btn_link']['url'] );

//     if ( $settings['btn_link']['is_external'] ) {

//         $this->add_render_attribute( 'btn_attr', 'target', '_blank' );

//     }

//     if ( ! empty( $settings['btn_link']['nofollow'] ) ) {

//         $this->add_render_attribute( 'btn_attr', 'rel', 'nofollow' );

//     }

// }

if($settings['btn_style'] == 'btn-flat')

{

  

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-flat' ); 

}

if($settings['btn_style'] == 'btn-outline')

{

  

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-outline' ); 

}

if($settings['btn_style'] == 'btn-link')

{

  

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-link' ); 

}

?>

<div class="gt-service-slider-box">

    <div class="owl-carousel" <?php echo $this->get_render_attribute_string('slider'); ?>>

        <?php

        foreach ( $tabs as $index => $item )

        {

            $title_html = $item['title_text'];

            $image_html = "";

            if ($item['image_style'] === "1") 

            {

                if (!empty($item['image']['url'])) 

                {

                    $image_html = '<img src="'.esc_url($item['image']['url']).'"   class="img-fluid"  alt="'.esc_attr(__('servicebox' , 'yog-core')).'" />';

                }

            }

            if ($item['image_style'] === "2")

            {

                if (!empty($item['selected_icon']['value']))

                {

                    $this->add_render_attribute('selected_icon', 'class', esc_attr($item['selected_icon']['value']));

                    $image_html .= '<div class="gt-service-media">';

                    $image_html .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('selected_icon'));

                    $image_html .= '</div>';

                }

            }

            if (!empty($item['title_text'])) 

            {

                $title_html = $item['title_text'];

            } else 

            {

                $title_html = "This is sample title";

            }

            if (!empty($item['subtitle_text'])) 

            {

                $subtitle_html = $item['subtitle_text'];

            } else 

            {

                $subtitle_html = "This is sample sub title";

            }

            if (!empty($item['pricetitle'])) 

            {

                $price_html = $item['pricetitle'];

            } else 

            {

                $price_html = "This is sample price";

            }

            if (!empty($item['description_text'])) 

            {

                $desc_html = $this->parse_text_editor($item['description_text']);

            } else

            {

                $desc_html = "Lorem Ipsum is simply dummy text of the printing and typesetting yog_.";

            }

            $title = sprintf('<%1$s class="gt-service-title">%2$s</%1$s>', $item['title_tag'],$title_html);

            

            if ($settings['service_style'] === "1")

            {

                ?>

                <div class="item">

                    <div class="gt-service-box gt-service-box-style-1">

                        <div class="gt-service-img">

                            <div class="gt-service-banner">

                                <?php echo $image_html; ?>

                            </div>

                        </div>

                        <div class="gt-service-info <?php echo $settings['content_align']; ?>">

                            <div class="gt-service-media">

                                <span><?php echo $price_html; ?> </span>

                            </div>

                            <div class="gt-sub-title">

                                <?php echo $subtitle_html; ?>

                            </div>

                            <a href="#"><?php echo $title; ?> </a>



                            <p class="gt-service-description"><?php echo $desc_html; ?>

                            <?php

                            if ( ! empty( $item['btn_link']['url'] ) ) 

                            {

                                $this->add_render_attribute( 'btn_attr'.$index, 'href', $item['btn_link']['url'] );

                                if ( $item['btn_link']['is_external'] ) {

                                    $this->add_render_attribute( 'btn_attr'.$index, 'target', '_blank' );

                                }

                                if ( ! empty( $item['btn_link']['nofollow'] ) ) {

                                    $this->add_render_attribute( 'btn_attr'.$index, 'rel', 'nofollow' );

                                }

                            } 

                            ?>



                            <div class="gt-btn-container">

                                <div class="gt-button-block">

                                    <a <?php echo $this->get_render_attribute_string('btn_attr'.$index); ?> <?php echo $this->get_render_attribute_string('btn_attr'); ?>> <span><?php echo $item['button_text']; ?></span></a>

                                </div>  

                            </div>



                        </div>

                    </div>

                </div>

                <?php

            } 

        }

        ?>

    </div>

</div>

