<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
}

$html = '';

$settings = $this->get_settings();
//$settings = $this->get_settings_for_display();


$title_html = $settings['title_text'];

$icon = "";



if (!empty($settings['selected_icon']['value'])) {
        $this->add_render_attribute('selected_icon', 'class', esc_attr($settings['selected_icon']['value']));
        $icon .= '<div class="gt-fancy-media">';
        $icon .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('selected_icon'));
        $icon .= '</div>';
    }

$image_html = "";
if ($settings['image_style'] === "1") {
    if (!empty($settings['image']['url'])) {
        $image_html = '<div class="gt-process-media img"><img src="'.esc_url($settings['image']['url']).'" alt="'.esc_attr(__('fancybox' , 'yog-core')).'" />
        <span class="gt-process-number">'.esc_html($settings['step_number']).'</span>
        </div>';

    }
}

if ($settings['image_style'] === "2") {
    if (!empty($settings['icon_class']['value'])) {
        $this->add_render_attribute('icon_class', 'class', esc_attr($settings['icon_class']['value']));
        $image_html .= '<div class="gt-process-media">';
        $image_html .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('icon_class'));
        $image_html .= '<span class="gt-process-number">'.esc_html($settings['step_number']).'</span>';
        $image_html .= '</div>';
    }

}


if (!empty($settings['title_text'])) {
    $title_html = $settings['title_text'];
} else {
    $title_html = "This is sample title";
}

if (!empty($settings['description_text'])) {
    $desc_html = $settings['description_text'];
} else {
    $desc_html = "Lorem Ipsum is simply dummy text of the printing and typesetting yog_.";
}

if (!empty($settings['sub_title_text'])) {
    $sub_title = $settings['sub_title_text'];
} else {
    $sub_title = "Simple Sub Title";
}
$title = sprintf('<%1$s class="gt-process-title">%2$s</%1$s>', $settings['title_tag'],$title_html);


?>
<?php 

if ($settings['layout_style'] === "1") 
{
?>

<div class="gt-process-step gt-process-1">
<?php echo $image_html; ?>
    <div class="gt-process-info">
        <?php echo $title; ?>        
        <p class="gt-process-description"><?php echo $desc_html; ?></p>
    </div>

     <?php 
           // require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';
       ?>
        
    <span class="gt-process-number"><?php echo esc_html($settings['step_number']); ?></span>
    
</div>

<?php } ?>

<?php 
if ($settings['layout_style'] === "2") 
{
?>
<div class="gt-process-step gt-process-2">

     <?php
        if($settings['use_before_img'] == 'yes') 
        {
        ?>
        <img class="gt-before-img" src="<?php echo esc_url($settings['arrow_img']['url']); ?>" alt="arrow-img">
    <?php } ?>
     <?php echo $image_html; ?>
    
    <div class="gt-process-info">
        <?php echo $title; ?>        
        <p class="gt-process-description"><?php echo $desc_html; ?></p>
    </div>

   <?php 
           // require YOG_PLUGIN_DIR . '/includes/elementor/render/btn.php';
       ?>
</div>

<?php } ?>