<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;
$settings = $this->get_settings_for_display();
$settings = $this->get_settings();
$theme_options = get_option('theme_options');
$lessons_title      = !empty($theme_options['lessons_title']) ? $theme_options['lessons_title'] : 'Lessons';
$students_title     = !empty($theme_options['students_title']) ? $theme_options['students_title'] : 'Students';
$query_args = [
	'post_type' => 'lp_course',
	'posts_per_page' => $settings['count'],
	'order' => $settings['order'],
	'ignore_sticky_posts' => 1,
	'post_status' => 'publish', // Hide drafts/private posts for admins
];
$post_array = new \WP_Query( $query_args );
$block_data = array(
	'box_style' => $settings['slider_style']
);
$this->add_render_attribute('slider', 'data-dots', $settings['dots']);
$this->add_render_attribute('slider', 'data-nav', $settings['nav_arrow']);
$this->add_render_attribute('slider', 'data-desk_num', $settings['desk_num']);
$this->add_render_attribute('slider', 'data-lap_num', $settings['lap_num']);
$this->add_render_attribute('slider', 'data-tab_num', $settings['tab_num']);
$this->add_render_attribute('slider', 'data-mob_num', $settings['mob_num']);
$this->add_render_attribute('slider', 'data-mob_sm', $settings['mob_num']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-loop', $settings['loop']);
$this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);
?>
<div class="service-box-style-course-slider">

<div class="owl-carousel" <?php echo $this->get_render_attribute_string('slider'); ?>>
			<?php
			if ( $post_array -> have_posts() ) 
      		{
				 while($post_array->have_posts())
				 {
					$post_array->the_post();
					?>
					<div class="item">
					<?php get_template_part( 'template-parts/course/block',  'style' , $block_data ); ?>
					</div>
				<?php  }
				 wp_reset_query();   
			}     
 			?>
			
			
		</div>
	</div>
