<?php
namespace Elementor;
if (!defined('ABSPATH')) {
	exit;
}

$html = '';

$settings = $this->get_settings();
// var_dump($settings['is_active']);
//$settings = $this->get_settings_for_display();

$this->add_inline_editing_attributes('title_text', 'none');
$this->add_inline_editing_attributes('description_text');
$title_html = $settings['title_text'];
$desc_html = $settings['description_text'];
$class = '';


$image_html = '';
if ($settings['image_style'] == '1') {
	if (!empty($settings['image']['url'])) {

		$this->add_render_attribute('image', 'src', $settings['image']['url']);
		$this->add_render_attribute('image', 'srcset', $settings['image']['url']);
		$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
		$this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
		$image_html = '<i><div class="gt-counter-img">' . Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image') .
			'</div></i>';

	}
}

if ($settings['image_style'] == '2') {
	if (!empty($settings['selected_icon']['value'])) {
		$this->add_render_attribute('selected_icon', 'class', esc_attr($settings['selected_icon']['value']));
		$image_html = sprintf('<div class="gt-counter-media"><i %1$s></i></div>', $this->get_render_attribute_string('selected_icon'));
	}

}
$prefix = '';
if ( 'yes' === $settings['show_prefix'] ) 
{
	$prefix = sprintf( '<span class="gt-counter-prefix">%1$s</span>', esc_html($settings['counter_prefix']));	
}
   $active = $settings['is_active'];

    if($active === "yes")
    {
        $class .= ' active';
    }

?>

 <div class="gt-counter-1 <?php echo $class; ?>">
 		<?php
 		if($settings['show_media'] == 'yes')
 		{ 
 		?>
 					<?php echo $image_html; ?>
 		<?php } ?>
 		<div class="gt-counter-info">
 			<div class="gt-counter-num-prefix">
 			 <h5 class="timer" data-to="<?php echo esc_html($title_html, 'yog-core') ?>" data-speed="5000"><?php echo esc_html($title_html); ?></h5>
 			 <?php echo $prefix; ?>
 			</div>
        	<p class="gt-counter-description"><?php echo strip_tags($this->parse_text_editor($desc_html)); ?></p>
 		</div> 
</div>
