<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
}

$html = '';

$settings = $this->get_settings();
//$settings = $this->get_settings_for_display();


$title_html = $settings['title_text'];

$image_html = "";
if ($settings['image_style'] === "1") {
    if (!empty($settings['image']['url'])) {
        $image_html = '<div class="gt-contact-box-media"><img src="'.esc_url($settings['image']['url']).'" alt="'.esc_attr(__('fancybox' , 'yog-core')).'" /></div>';

    }
}

if ($settings['image_style'] === "2") {
    if (!empty($settings['selected_icon']['value'])) {
        $this->add_render_attribute('selected_icon', 'class', esc_attr($settings['selected_icon']['value']));
        $image_html .= '<div class="gt-contact-box-media">';
        $image_html .= sprintf('<i %1$s></i>', $this->get_render_attribute_string('selected_icon'));
        $image_html .= '</div>';
    }

}

if (!empty($settings['title_text'])) {
    $title_html = $settings['title_text'];
} else {
    $title_html = "This is sample title";
}

if (!empty($settings['description_text']) && $settings['has_desc'] == 'yes') {
    $desc_html = '<p class="gt-description">'.$this->parse_text_editor($settings['description_text']).'</p>';
}
else{
   $desc_html = '';
}




$title = sprintf('<%1$s class="gt-contact-box-title">%2$s</%1$s>', $settings['title_tag'],$title_html);

if ($settings['layout_style'] === "1") {
    ?>
<div class="gt-contact-box gt-contact-box-1">
    <?php echo $image_html; ?>
    <div class="gt-contact-box-info">
        
        <?php echo $title; ?>      
        
        <?php $desc_html; ?>
        <ul class="gt-contact-info">
              <li>
                <span>

                  <i class="<?php echo esc_attr($settings['address_icon']['value']); ?>"></i>
                <span><?php echo esc_attr($settings['address']) ?></span>
                </span>
            </li>
            <li>
                <span>
                    <i class="<?php echo esc_attr($settings['phone_icon']['value']); ?>"></i>
                    <span>
                        <a href="tel:<?php echo str_replace(str_split('(),-" '), '',$settings['number_1']); ?>"><?php echo esc_attr($settings['number_1']) ?></a>
                        <a href="tel:<?php echo str_replace(str_split('(),-" '), '',$settings['number_2']); ?>"><?php echo esc_attr($settings['number_2']) ?></a>
                    </span>
                    
                </span>                
            </li>
           
            <li>
                <span>
                    <i class="<?php echo esc_attr($settings['email_icon']['value']); ?>"></i>
                    <span>
                        <a href="mailto:<?php echo esc_html($settings['email_1']); ?>">
                            <?php echo esc_attr($settings['email_1']) ?>

                        </a>
                         <a href="mailto:<?php echo esc_html($settings['email_2']); ?>">
                            <?php echo esc_attr($settings['email_2']) ?>
                        </a>
                    </span>
                    
                </span>
            </li>
           
          

        </ul>
        
    </div>
</div>

<?php
}



