<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 
$tabs = $this->get_settings_for_display( 'tabs' );
$settings = $this->get_settings();
if(!empty($settings['custom_dimension']['width']))
{
  $width = $settings['custom_dimension']['width'];
  $this->add_render_attribute('custom_width', 'style', 'width:'.$width.'px;');
}
if(!empty($settings['custom_dimension']['height']))
{
  $height = $settings['custom_dimension']['height'];
  $this->add_render_attribute('custom_width', 'style', 'height:'.$height.'px;'); 
}

if($settings['layout_style'] == 'slider')
{
  $this->add_render_attribute('slider', 'data-dots', $settings['dots']);
  $this->add_render_attribute('slider', 'data-nav', $settings['nav_arrow']);
  $this->add_render_attribute('slider', 'data-desk_num', $settings['desk_num']);
  $this->add_render_attribute('slider', 'data-lap_num', $settings['lap_num']);
  $this->add_render_attribute('slider', 'data-tab_num', $settings['tab_num']);
  $this->add_render_attribute('slider', 'data-mob_num', $settings['mob_num']);
  $this->add_render_attribute('slider', 'data-mob_sm', $settings['mob_num']);
  $this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
  $this->add_render_attribute('slider', 'data-loop', $settings['loop']);
  $this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);
  ?>
  <div class="gt-client">
    <div class="owl-carousel" <?php echo $this->get_render_attribute_string('slider'); ?>>
     <?php 
     foreach ( $tabs as $index => $item )
     {
      ?>
      <div class="item">
        <div class="gt-clientbox-1">
          <a>
            <img class="gt-client-img" src="<?php echo $item['tab_image']['url']; ?>" alt="gt-client-img" <?php echo $this->get_render_attribute_string('custom_width'); ?>>
            <img class="gt-client-hover-img" src="<?php echo $item['tab_image_1']['url']; ?>" alt="gt-client-img" <?php echo $this->get_render_attribute_string('custom_width'); ?>> 
          </a>
        </div>
      </div>

    <?php } 

    ?>
  </div>
</div>
<?php } ?>
<?php  
if($settings['layout_style'] == 'grid')
{
  ?>
  <div class="gt-client">
    <div class="row">
     <?php 
     foreach ( $tabs as $index => $item )
     {
      ?>
      <div class="col-lg-<?php echo esc_attr($settings['grid_style']); ?> col-md-4">
        <div class="gt-client-grid">
          <img class="gt-client-img" src="<?php echo $item['tab_image']['url']; ?>" alt="gt-client-img">
          <img class="gt-client-hover-img" src="<?php echo $item['tab_image_1']['url']; ?>" alt="gt-client-img">
        </div>

      </div>

    <?php } 

    ?>
  </div>
</div>
<?php }
