<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;
$html = '';

$settings = $this->get_settings();
//$settings = $this->get_settings_for_display();


$title_html = $settings['button_text'];


$this->add_render_attribute( 'btn_attr', 'class', 'gt-button' );

if ( ! empty( $settings['btn_link']['url'] ) )
{
    $this->add_render_attribute( 'btn_attr', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $this->add_render_attribute( 'btn_attr', 'target', '_blank' );
    }

    if ( ! empty( $settings['btn_link']['nofollow'] ) ) {
        $this->add_render_attribute( 'btn_attr', 'rel', 'nofollow' );
    }
}

if($settings['btn_style'] == 'btn-flat')
{

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-flat' );
}

if($settings['btn_style'] == 'btn-outline')
{

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-outline' );
}

if($settings['btn_style'] == 'btn-link')
{

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-link' );
}
$icon = '';

if($settings['btn_has_icon'] == 'yes')
{
  $icon =  sprintf('<i class="%1$s pt-btn-icon"></i>', $settings['btn_selected_icon']['value']);
}

?>
<div class="gt-btn-container">
    <div class="gt-button-block">
			<a <?php echo $this->get_render_attribute_string('btn_attr'); ?>> <span><?php echo $title_html; ?></span> <?php echo $icon; ?>
</a>

    </div>

</div>


<?php
$this->add_render_attribute( 'btn_attr', 'href', '' );
?>