<?php

namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) 

{

  exit; 

}

$settings = $this->get_settings();

$hide = (bool) ($settings['blog_hides']);

$align = $settings['text_align'];

 

$this->add_render_attribute( 'btn_attr', 'class', 'gt-button' ); 

if($settings['btn_style'] == 'btn-flat')

{

  

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-flat' ); 

}

if($settings['btn_style'] == 'btn-outline')

{

  

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-outline' ); 

}

if($settings['btn_style'] == 'btn-link')

{

  

  $this->add_render_attribute( 'btn_attr', 'class', 'gt-btn-link' ); 

}

   global $paged;

  if (empty($paged)) {

  $paged = 1;

  }

  $args = array(

  'post_type'         => 'post',

  'post_status'       => 'publish',    

  'suppress_filters'  => 0,

  'paged' => $paged

  );

  $posts = new \WP_Query($args);

  

  

  

  if($settings['blog_style'] === "0")

  {

      $this->add_render_attribute('slider', 'data-dots', $settings['dots']);

$this->add_render_attribute('slider', 'data-nav', $settings['nav_arrow']);

$this->add_render_attribute('slider', 'data-desk_num', $settings['desk_num']);

$this->add_render_attribute('slider', 'data-lap_num', $settings['lap_num']);

$this->add_render_attribute('slider', 'data-tab_num', $settings['tab_num']);

$this->add_render_attribute('slider', 'data-mob_num', $settings['mob_num']);

$this->add_render_attribute('slider', 'data-mob_sm', $settings['mob_num']);

$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);

$this->add_render_attribute('slider', 'data-loop', $settings['loop']);

$this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);

  ?>

<div class="gt-blog text-<?php echo esc_attr($align,'yog-core'); ?>"> 

  <div class="owl-carousel" <?php echo $this->get_render_attribute_string('slider'); ?>>

    

    <?php 

      if ( $posts -> have_posts() ) 

      {

          while ( $posts -> have_posts() ) 

          {

            $posts->the_post();

      

            $image_PEACEFULQODE_PLUGIN_URL = Group_Control_Image_Size::get_attachment_image_src( get_post_thumbnail_id(  ), 'thumbnail', $settings );

      ?>

    <div class="item">

      <div class="gt-blog-post">

    

      <?php

        if(has_post_thumbnail())

        {

      ?>

        <div class="gt-post-media">

        <?php  the_post_thumbnail(); ?>

        <?php

            $archive_year  = get_the_time( 'Y' ); 

            $archive_month = get_the_time( 'm' ); 

            $archive_day   = get_the_time( 'd' ); 

            ?>

        <div class="gt-post-date">

          <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">

          <span><?php echo esc_html( get_the_date('d M',get_the_ID())); ?></span> <?php echo esc_html( get_the_date('Y',get_the_ID()));?></a>

        </div>

        

      </div>

      <?php 

        } 

      ?>

    

    <div class="gt-blog-contain">

      

    

      <?php

      if(!is_single())

      {

      ?>

       <?php

      if(!is_single())

      {

      ?>

      <h5 class="gt-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

      <?php } ?>

      <?php } ?>

     

          <?php

          if ( !(bool) $hide){

    

         

            the_excerpt();

           

   }

            ?> 

          

    <div class="gt-post-meta">

       

      <ul>  

        <?php $im = get_avatar( get_the_author_meta( 'ID' ), 32 ); 

           ?>

        

        <li class="gt-post-author">

          <div class="gt-post-authors">

            <?php echo $im; ?><span>By <?php the_author(); ?></span>

          </div>

        </li>

        <li class="gt-post-comment">

          <?php 

          if(get_comments_number(get_the_ID()) == 1)

          {

            $comment = esc_html__('Comment','gymster');

          }

          else

          {

            $comment = esc_html__('Comments','gymster');

          }

          ?>

            <a href="<?php the_permalink(); ?>"><i class="fa fa-comments"></i>

              <?php echo get_comments_number(get_the_ID()).' '.$comment; ?></a> 

        </li>

       

      </ul>

    </div>

            <?php 

          

          wp_link_pages( array(

            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'yog-core' ),

            'after'       => '</div>',

            'link_before' => '<span class="page-number">',

            'link_after'  => '</span>',

          ) );

          ?>

     

          

    </div>

</div>

    </div>

    <?php 

      }

      }  

      wp_reset_query();

      ?>

  </div>

</div>

<?php 

  }

  

  

  

  else

  {

   

    $pagination_args = array(

    //'base'            => get_pagenum_link(1) . '%_%',

    'format'      => '?paged=%#%',

    'total'           => $posts->max_num_pages,

    'current'         => $paged,

    'show_all'        => False,

    'end_size'        => 1,

    'mid_size'        => 2,

    'prev_next'       => True,

    'prev_text'       =>  esc_html__( 'Previous page', 'yog-core' ),

    'next_text'       => esc_html__( 'Next page', 'yog-core' ),

    'type'            => 'list',

    'add_args'        => false,

    'add_fragment'    => ''

    );    

   $paginate_links = paginate_links($pagination_args);

    if($settings['blog_style'] === "1")

    {

        $col = 'col-lg-12';

        $grid = 'gt-blog-col-1';

    }

    if($settings['blog_style'] === "2")

    {

        $col = 'col-lg-6';

        $grid = 'gt-blog-col-2';

    }

    if($settings['blog_style'] === "3")

    {

        $col = 'col-lg-4';

        $grid = 'gt-blog-col-3';

    }

  ?>

<div class="gt-blog <?php echo esc_attr($grid); ?>">

  <div class="row">   

    

    <?php 

      if ( $posts -> have_posts() ) 

      {

      while ( $posts -> have_posts() ) 

      {

        $posts->the_post();

      

        $image_PEACEFULQODE_PLUGIN_URL = Group_Control_Image_Size::get_attachment_image_src( get_post_thumbnail_id( $posts->ID ), 'thumbnail', $settings );

      ?>

    <div class="<?php echo esc_attr__($col,'yog-core'); ?>">

     <div class="gt-blog-post">

    

      <?php

        if(has_post_thumbnail())

        {

      ?>

        <div class="gt-post-media">

        <?php  the_post_thumbnail(); ?>

        <?php

            $archive_year  = get_the_time( 'Y' ); 

            $archive_month = get_the_time( 'm' ); 

            $archive_day   = get_the_time( 'd' ); 

            ?>

        <div class="gt-post-date">

          <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">

          <span><?php echo esc_html( get_the_date('d M',get_the_ID())); ?></span> <?php echo esc_html( get_the_date('Y',get_the_ID()));?></a>

        </div>

        

      </div>

      <?php 

        } 

      ?>

    

    <div class="gt-blog-contain">

      

    

      <?php

      if(!is_single())

      {

      ?>

       <?php

      if(!is_single())

      {

      ?>

      <h5 class="gt-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

      <?php } ?>

      <?php } ?>

     

          <?php

          if ( !(bool) $hide){

    

         

            the_excerpt();

           

   }

            ?> 

          

    <div class="gt-post-meta">

       

      <ul>  

        <?php $im = get_avatar( get_the_author_meta( 'ID' ), 32 ); 

           ?>

        

        <li class="gt-post-author">

          <div class="gt-post-authors">

            <?php echo $im; ?><span>By <?php the_author(); ?></span>

          </div>

        </li>

        <li class="gt-post-comment">

          <?php 

          if(get_comments_number(get_the_ID()) == 1)

          {

            $comment = esc_html__('Comment','gymster');

          }

          else

          {

            $comment = esc_html__('Comments','gymster');

          }

          ?>

            <a href="<?php the_permalink(); ?>"><i class="fa fa-comments"></i>

              <?php echo get_comments_number(get_the_ID()).' '.$comment; ?></a> 

        </li>

       

      </ul>

    </div>

            <?php 

          

          wp_link_pages( array(

            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'yog-core' ),

            'after'       => '</div>',

            'link_before' => '<span class="page-number">',

            'link_after'  => '</span>',

          ) );

          ?>

     

          

    </div>

</div>

    

    <?php 

      }

      if ($paginate_links) {

  

        echo '<div class="col-lg-12 col-md-12 col-sm-12">

          <div class="gt-pagination">       

              <nav aria-label="Page navigation">';

              printf( esc_html__('%s','yog-core'),$paginate_links);

              echo '</nav>

            </div>

          </div>';

    }

      

      }  

      wp_reset_query();

      

      ?>

  </div>

</div>

<?php 

}

?>