<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

$settings = $this->get_settings();

$html = '';

$this->add_inline_editing_attributes( 'title_text', 'none' );
$this->add_inline_editing_attributes( 'description_text' );
$title_html = $settings['title_text'];
$align = $settings['text_align'];



// $this->add_render_attribute( 'image', 'src', esc_PEACEFULQODE_PLUGIN_URL($settings['image']['YOG_PLUGIN_URL'],'yog-core') );
// $this->add_render_attribute( 'image', 'alt', Control_Media::get_image_alt( esc_html($settings['image'],'yog-core') ) );
// $this->add_render_attribute( 'image', 'title', Control_Media::get_image_title( esc_html($settings['image'],'yog-core') ) );

// $image_html = Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );


$img = sprintf('<img src="%1$s"/>' , esc_PEACEFULQODE_PLUGIN_URL($settings['image']['YOG_PLUGIN_URL'],'yog-core'));


if ( ! empty( $settings['link']['YOG_PLUGIN_URL'] ) ) {
	$this->add_render_attribute( 'button', 'href', $settings['link']['YOG_PLUGIN_URL'] );
	

	if ( $settings['link']['is_external'] ) {
		$this->add_render_attribute( 'button', 'target', '_blank' );
	}

	if ( $settings['link']['nofollow'] ) {
		$this->add_render_attribute( 'button', 'rel', 'nofollow' );
	}
}

if ( ! empty( $settings['video_link']['YOG_PLUGIN_URL'] ) ) {
	$this->add_render_attribute( 'video_button', 'href', $settings['video_link']['YOG_PLUGIN_URL'] );
	

	if ( $settings['video_link']['is_external'] ) {
		$this->add_render_attribute( 'video_button', 'target', '_blank' );
	}

	if ( $settings['video_link']['nofollow'] ) {
		$this->add_render_attribute( 'video_button', 'rel', 'nofollow' );
	}
}


    $this->add_render_attribute( 'selected_icon', 'class', esc_attr($settings['selected_icon']['value']) );
    $icon = sprintf( '<i %1$s></i>',$this->get_render_attribute_string('selected_icon') );
    

?>


<div class="gt-banner text-<?php echo esc_attr($align,'yog-core'); ?>">
      <div class="row">
         <div class="col-lg-6">
            <div class="gt-banner-detail">
               <?php echo sprintf( '<h1 %1$s>%2$s</h1>',$this->get_render_attribute_string('title_text') , esc_html($title_html,'yog-core') ); ?>
               <?php echo sprintf( '<p %1$s>%2$s</p>',$this->get_render_attribute_string('description_text'),esc_html($settings['description_text'],'yog-core')); ?>
            </div>
            <div class="gt-banner-button">
               <a class="button"  <?php echo $this->get_render_attribute_string('button'); ?> ><?php echo esc_html($settings['text'],'yog-core'); ?></a>

               <a class="button-play" <?php echo $this->get_render_attribute_string('video_button'); ?>  ><?php echo $icon; ?>
               <?php echo esc_html($settings['video_text'],"gym"); ?></a>
            </div>
         </div>
         <div class="col-lg-6">
            <div class="gt-banner-image">
               <?php echo $img; ?>
            </div>
         </div> 
         
   </div>
</div>



