<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

	
		// Button Style Section
		$this->start_controls_section(
			'section_y8ubBfbAH1e2VwpN5be9',
			[
				'label' => __( 'Button Style', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);

		  $this->add_responsive_control(
			'button_text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'default'    => 'left',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]				
		 		],
		 		'selectors' => [
					'{{WRAPPER}} .gt-btn-container' => 'text-align: {{VALUE}};',
				]
			]
        );

		$this->add_control(
            'btn_style',
            [   
                'type' => 'image_select_control',
                'option' => [
                				'btn-flat' => 'https://via.placeholder.com/200x80.png?text=btn-flat', 
                				'btn-outline' => 'https://via.placeholder.com/200x80.png?text=btn-outline', 
                				'btn-link' => 'https://via.placeholder.com/200x80.png?text=btn-link', 
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );
        
         
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-button-block .gt-button span',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .gt-button-block .gt-button span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => __( 'Background Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color1',
			[
				'label' => __( 'Background Line Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button .gt-button-line-left' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button-block .gt-button:hover span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label' => __( 'Background Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button::before' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_background_hover_color1',
			[
				'label' => __( 'Background Line Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button:hover .gt-button-line-left' => 'background-color: {{VALUE}};',
				],
			]
		);
		

		$this->end_controls_tab();


		$this->end_controls_tabs();

		$this->end_controls_section();
