<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;



		$this->add_control(
			'button_text',
			[
				'label' => __( 'Button Text', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Click Here', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );
        $this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'yog-core' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'yog-core' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'btn_has_icon',
			[
				'label' => __( 'Use Icon?', 'architek-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'architek-core' ),
				'no' => __( 'no', 'architek-core' ),
			]
        );

		$this->add_control(
			'btn_selected_icon',
			[
				'label' => __( 'Icon', 'architek-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-android-arrow-dropright',

				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'btn_has_icon' => 'yes',
				]
			]
		);


        $this->add_responsive_control(
			'button_text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'default'    => 'left',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
		 		],
		 		'selectors' => [
					'{{WRAPPER}} .gt-btn-container' => 'text-align: {{VALUE}};',
				]
			]
        );
		$this->end_controls_section();





		// Button Style Section
		$this->start_controls_section(
			'section_y8ubBfbAH1e2VwpN5be9',
			[
				'label' => __( 'Button Style', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,

			]
		);

		$this->add_control(
            'btn_style',
            [
                'type' => 'image_select_control',
                'option' => [
                				'btn-flat' => 'https://via.placeholder.com/200x80.png?text=btn-flat',
                				'btn-outline' => 'https://via.placeholder.com/200x80.png?text=btn-outline',
                				'btn-link' => 'https://via.placeholder.com/200x80.png?text=btn-link',

                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'plugin-domain' ),

				'selector' => '{{WRAPPER}} .gt-button-block .gt-button span',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .gt-button-block .gt-button span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => __( 'Background Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color1',
			[
				'label' => __( 'Background Line Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .gt-button:before' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button-block .gt-button:hover span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label' => __( 'Background Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_background_hover_color1',
			[
				'label' => __( 'Background Line Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-button:after:hover' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .gt-button:befor:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->end_controls_tab();


		$this->end_controls_tabs();

		$this->end_controls_section();
		$this->start_controls_section(
			'section__6620101',
			[
				'label' => __( 'Button Icon', 'architek-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'btn_has_icon' => 'yes',
				]

			]
		);

		$this->start_controls_tabs( 'tabs__7a87179' );
         $this->start_controls_tab(
            'tabs__998a8d7',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );
         $this->add_control(
			'icon_color_s3w1o04',
			[
				'label' => __( 'Color', 'architek-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pt-btn-container .pt-btn-icon' => 'color: {{VALUE}};',
		 		],


			]
		);
         $this->add_responsive_control(
			'font_size__d2VjaF4',
			[
				'label' => __( 'Font Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],

				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .pt-btn-container .pt-btn-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
         $this->end_controls_tab();
          $this->start_controls_tab(
            'tabs__10c333a',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
         $this->add_control(
			'icon_color__10c333a',
			[
				'label' => __( 'Color', 'architek-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pt-btn-container .pt-btn-icon:hover' => 'color: {{VALUE}};',
		 		],


			]
		);
          $this->add_responsive_control(
			'font_size_hover__d2VjaF4',
			[
				'label' => __( 'Font Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],

				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .pt-btn-container .pt-btn-icon:hover' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
         $this->end_controls_tab();

         $this->end_controls_tabs();

		$this->end_controls_section();
