<?php
add_action( 'init', 'yog_team' );
function yog_team() {
	$labels = array(
		'name'                  => esc_html__( 'Team Member', 'post type general name', 'yog-core' ),
		'singular_name'         => esc_html__( 'Team Member', 'post type singular name', 'yog-core' ),
		'featured_image'        => esc_html__( 'Team Member Photo', 'yog-core'  ),
		'set_featured_image'    => esc_html__( 'Set Team Member Photo', 'yog-core'  ),
		'remove_featured_image' => esc_html__( 'Remove Team Member Photo', 'yog-core'  ),
		'use_featured_image'    => esc_html__( 'Use as Team Member Photo', 'yog-core'  ),
		'menu_name'             => esc_html__( 'Our Team', 'admin menu', 'yog-core' ),
		'name_admin_bar'        => esc_html__( 'Team Member', 'add new on admin bar', 'yog-core' ),
		'add_new'               => esc_html__( 'Add New', 'Team Member', 'yog-core' ),
		'add_new_item'          => esc_html__( 'Add New Team Member', 'yog-core' ),
		'new_item'              => esc_html__( 'New Team Member', 'yog-core' ),
		'edit_item'             => esc_html__( 'Edit Team Member', 'yog-core' ),
		'view_item'             => esc_html__( 'View Team Member', 'yog-core' ),
		'all_items'             => esc_html__( 'All Team Members', 'yog-core' ),
		'search_items'          => esc_html__( 'Search Team Member', 'yog-core' ),
		'parent_item_colon'     => esc_html__( 'Parent Team Member:', 'yog-core' ),
		'not_found'             => esc_html__( 'No Classs found.', 'yog-core' ),
		'not_found_in_trash'    => esc_html__( 'No Classs found in Trash.', 'yog-core' )
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'team' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'			 => 'dashicons-businessman',
		'supports'           => array( 'title', 'thumbnail' , 'editor')
	);

	register_post_type( 'team', $args );
}





add_action( 'init', 'yog_portfolio' );
function yog_portfolio() {
	$labels = array(
		'name'                  => esc_html__( 'Portfolio', 'post type general name', 'yog-core' ),
		'singular_name'         => esc_html__( 'Portfolio', 'post type singular name', 'yog-core' ),
		'featured_image'        => esc_html__( 'Portfolio Photo', 'yog-core'  ),
		'set_featured_image'    => esc_html__( 'Set Portfolio Photo', 'yog-core'  ),
		'remove_featured_image' => esc_html__( 'Remove Portfolio Photo', 'yog-core'  ),
		'use_featured_image'    => esc_html__( 'Use as Portfolio Photo', 'yog-core'  ),
		'menu_name'             => esc_html__( 'Portfolio', 'admin menu', 'yog-core' ),
		'name_admin_bar'        => esc_html__( 'Portfolio', 'add new on admin bar', 'yog-core' ),
		'add_new'               => esc_html__( 'Add New', 'Portfolio', 'yog-core' ),
		'add_new_item'          => esc_html__( 'Add New Portfolio', 'yog-core' ),
		'new_item'              => esc_html__( 'New Portfolio', 'yog-core' ),
		'edit_item'             => esc_html__( 'Edit Portfolio', 'yog-core' ),
		'view_item'             => esc_html__( 'View Portfolio', 'yog-core' ),
		'all_items'             => esc_html__( 'All Portfolio', 'yog-core' ),
		'search_items'          => esc_html__( 'Search Portfolio', 'yog-core' ),
		'parent_item_colon'     => esc_html__( 'Parent Portfolio :', 'yog-core' ),
		'not_found'             => esc_html__( 'No Classs found.', 'yog-core' ),
		'not_found_in_trash'    => esc_html__( 'No Classs found in Trash.', 'yog-core' )
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => true,
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'			 => 'dashicons-category',
		'supports'           => array( 'title', 'editor', 'thumbnail','category','tag')
	);

	register_post_type( 'portfolio', $args );
}



add_action( 'after_setup_theme', 'custom_taxonomy' );
function custom_taxonomy() {
	register_taxonomy(
		'portfolio-categories',
		'portfolio',
		array(
			'label' => esc_html__( 'Portfolio Category', 'yog-core' ),
			'rewrite' => true,
			'hierarchical' => true,
		)
	);
	register_taxonomy(
		'portfolio-tag',
		'portfolio',
		array(
			'label' => esc_html__( 'Portfolio Tag', 'yog-core' ),
			'rewrite' => true,
			'hierarchical' => true,
		)
	);
}


// add_action( 'init', 'testimonial_gallery' );
// function testimonial_gallery() {
// 	$labels = array(
// 		'name'               => esc_html__( 'Testimonial', 'post type general name', 'yog-core' ),
// 		'singular_name'      => esc_html__( 'Testimonial', 'post type singular name', 'yog-core' ),
// 		'featured_image'        => esc_html__( 'Photo', 'yog-core'  ),
// 		'set_featured_image'    => esc_html__( 'Set Photo', 'yog-core'  ),
// 		'remove_featured_image' => esc_html__( 'Remove Photo', 'yog-core'  ),
// 		'use_featured_image'    => esc_html__( 'Use as Photo', 'yog-core'  ),
// 		'menu_name'          => esc_html__( 'Testimonial', 'admin menu', 'yog-core' ),
// 		'name_admin_bar'     => esc_html__( 'Testimonial', 'add new on admin bar', 'yog-core' ),
// 		'add_new'            => esc_html__( 'Add New', 'Testimonial', 'yog-core' ),
// 		'add_new_item'       => esc_html__( 'Add New Testimonial', 'yog-core' ),
// 		'new_item'           => esc_html__( 'New Testimonial', 'yog-core' ),
// 		'edit_item'          => esc_html__( 'Edit Testimonial', 'yog-core' ),
// 		'view_item'          => esc_html__( 'View Testimonial', 'yog-core' ),
// 		'all_items'          => esc_html__( 'All Testimonial', 'yog-core' ),
// 		'search_items'       => esc_html__( 'Search Testimonial', 'yog-core' ),
// 		'parent_item_colon'  => esc_html__( 'Parent Testimonial:', 'yog-core' ),
// 		'not_found'          => esc_html__( 'No Testimonial found.', 'yog-core' ),
// 		'not_found_in_trash' => esc_html__( 'No Testimonial found in Trash.', 'yog-core' )
// 	);

// 	$args = array(
// 		'labels'             => $labels,
// 		'public'             => true,
// 		'publicly_queryable' => true,
// 		'show_ui'            => true,
// 		'show_in_menu'       => true,
// 		'query_var'          => true,
// 		'rewrite'            => array( 'slug' => 'testimonial' ),
// 		'capability_type'    => 'post',
// 		'has_archive'        => true,
// 		'hierarchical'       => false,
// 		'menu_position'      => null,
// 		'menu_icon'			 => 'dashicons-format-gallery',
// 		'supports'           => array( 'title', 'editor', 'thumbnail')
// 	);

// 	register_post_type( 'testimonial', $args );
// }
?>