(function (jQuery) {
  "use strict";
  jQuery(document).ready(function () {
  });
  jQuery(window).on('load', function (e) {
    /*----------------
       Timeline
       ---------------------*/

   jQuery('.timeline').each(function() {
      var app_slider = jQuery(this);
      console.log(jQuery(this).data('forceVerticalMode'));
      console.log(app_slider.data('forceVerticalMode'));

      app_slider.timeline({
      visibleItems: app_slider.data("desk_num"),
      mode: 'horizontal',
      // forceVerticalMode: 500,
        });
      });
      if(jQuery('.learn-press-form-login').hasClass('learn-press-form')){
        jQuery('body').addClass('profiles-login');
    } 
       /*----------------
       Counter
       ---------------------*/
    jQuery('.timer').countTo();
    jQuery('p:empty').remove();
    /*----------------
           image grid 
    ---------------------*/
    // external js: isotope.pkgd.js
    jQuery(".grid").isotope({
      itemSelector: ".grid-item",
      percentPosition: true,
      masonry: {
        columnWidth: ".grid-sizer"
      }
    });
    /*----------------
        Tox Progress Bar
        ---------------------*/
    jQuery('.gt-circle-progress-bar').each(function () {
      var number = jQuery(this).data('skill-level');
      var empty_color = jQuery(this).data('empty-color');
      var fill_color = jQuery(this).data('fill-color');
      var size = jQuery(this).data('size');
      var thickness = jQuery(this).data('thickness');
      jQuery(this).circleProgress({
        value: '0.' + number,
        size: size,
        emptyFill: empty_color,
        fill: {
          color: fill_color
        }
      }).on('circle-animation-progress', function (event, progress) {
        jQuery(this).find('.gt-progress-count').html(Math.round(number * progress) + '%');
      });
    });
    jQuery('.gt-progress-bar > span').each(function () {
      var progress_bar = jQuery(this);
      var width = jQuery(this).data('percent');
      progress_bar.css({
        'transition': 'width 2s'
      });
      jQuery('.progress-value').css({
        'transition': 'margin 2s'
      });
      setTimeout(function () {
        jQuery(this).show(function () {
          progress_bar.css('width', width + '%');
        });
      }, 500);
      setTimeout(function () {
        jQuery('.gt-progressbar-style-2 .progress-value').show(function () {
          jQuery('.gt-progressbar-style-2 .progress-value').css('margin-left', width + 'px');
        });
      }, 500);
      setTimeout(function () {
        jQuery('.gt-progressbar-style-3 .progress-tooltip').show(function () {
          jQuery('.gt-progressbar-style-3 .progress-tooltip').css('margin-left', width + 'px');
        });
      }, 500);
    });
    /*------------------------
        Accordion
       --------------------------*/
    jQuery('.gt-accordion-block .gt-accordion-box .gt-accordion-details').hide();
    jQuery('.gt-accordion-block .gt-accordion-box:first').addClass('gt-active').children().slideDown('slow');
    jQuery('.gt-accordion-block .gt-accordion-box').on("click", function () {
      if (jQuery(this).children('div.gt-accordion-details').is(':hidden')) {
        jQuery('.gt-accordion-block .gt-accordion-box').removeClass('gt-active').children('div.gt-accordion-details').slideUp('slow');
        jQuery(this).toggleClass('gt-active').children('div.gt-accordion-details').slideDown('slow');
      }
    });
    /*------------------------
    Owl Carousel
    --------------------------*/
    jQuery('.owl-carousel').each(function () {
      var app_slider = jQuery(this);
      var center = false;
      if (jQuery(this).parent('.gt-fancy-box-slider.gt-fancy-box-slider-1').length > 0) {
        center = true;
      }
      app_slider.owlCarousel({
        items: app_slider.data("desk_num"),
        loop: app_slider.data("loop"),
        margin: app_slider.data("margin"),
        nav: app_slider.data("nav"),
        center: center,
        dots: app_slider.data("dots"),
        autoplay: app_slider.data("autoplay"),
        autoplayTimeout: app_slider.data("autoplay-timeout"),
        navText: ["<i class='ion-ios-arrow-back'></i><span>Prev</span>", "<span>Next</span><i class='ion-ios-arrow-forward'></i>"],
        responsiveClass: true,
        responsive: {
          // breakpoint from 0 up
          0: {
            items: app_slider.data("mob_sm"),
            nav: false,
            // dots: true
          },
          // breakpoint from 480 up
          480: {
            items: app_slider.data("mob_num"),
            nav: false,
            // dots: true
          },
          // breakpoint from 786 up
          767: {
            items: app_slider.data("tab_num")
          },
          // breakpoint from 1023 up
          1023: {
            items: app_slider.data("lap_num")
          },
          1199: {
            items: app_slider.data("desk_num")
          }
        }
      });
    });
    jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps, .button-play').magnificPopup({
      type: 'iframe',
      mainClass: 'mfp-fade',
      preloader: true,
    });
    setTimeout(init, 1000);
    function init() {
      jQuery('.content__image-wrap').each(function () {
        var watcher_id = jQuery(this).attr('id');
        var color = jQuery(this).data("color")
        var direction = jQuery(this).data("direction")
        var scrollElemToWatch_1 = document.getElementById(watcher_id);
        var watcher_1 = scrollMonitor.create(scrollElemToWatch_1, -300);
        var rev3 = new RevealFx(scrollElemToWatch_1, {
          revealSettings: {
            bgcolor: color,
            direction: direction,
            onCover: function (contentEl, revealerEl) {
              contentEl.style.opacity = 1;
            }
          }
        });
        watcher_1.enterViewport(function () {
          rev3.reveal();
          watcher_1.destroy();
        });
      });
    }
  });
})(jQuery);