jQuery(function (jQuery) {
	 "use strict";

jQuery(window).on('load', function(e) {
	jQuery('.gt-masonry').isotope({
          itemSelector: '.gt-masonry-item',      
            masonry: {
              columnWidth: '.grid-sizer',
              gutter: 0
            }
           
      });

      jQuery('.gt-grid').isotope({
          itemSelector: '.gt-grid-item',
             
      });

       jQuery('.gt-filter-button-group').on( 'click', '.gt-filter-btn', function() {
        
        var filterValue = jQuery(this).attr('data-filter');
        jQuery('.gt-masonry').isotope({ filter: filterValue });
        jQuery('.gt-grid').isotope({ filter: filterValue });
        jQuery('.gt-filter-button-group .gt-filter-btn').removeClass('active');
        jQuery(this).addClass('active');
        
        
        updateFilterCounts();

      });

       var initial_items = 5;
       var next_items = 3;
	
	if(jQuery('.gt-masonry').length > 0)
		{
			var initial_items = jQuery('.gt-masonry').data('initial_items');
			var next_items = jQuery('.gt-masonry').data('next_items');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			var initial_items = jQuery('.gt-grid').data('initial_items');
			var next_items = jQuery('.gt-grid').data('next_items');
		}

	function showNextItems(pagination) {
		var itemsMax = jQuery('.visible_item').length;
		var itemsCount = 0;
		jQuery('.visible_item').each(function () {
			if (itemsCount < pagination) {
				jQuery(this).removeClass('visible_item');
				itemsCount++;
			}
		});
		if (itemsCount >= itemsMax) {
			jQuery('#showMore').hide();
		}
		
		if(jQuery('.gt-masonry').length > 0)
		{
			jQuery('.gt-masonry').isotope('layout');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			jQuery('.gt-grid').isotope('layout');
		}

		
		
	}
	// function that hides items when page is loaded
	function hideItems(pagination) {
		var itemsMax = jQuery('.gt-filter-items').length;
		
		var itemsCount = 0;
		jQuery('.gt-filter-items').each(function () {
			if (itemsCount >= pagination) {
				jQuery(this).addClass('visible_item');
			}
			itemsCount++;
		});
		if (itemsCount < itemsMax || initial_items >= itemsMax) {
			jQuery('#showMore').hide();
		}
		if(jQuery('.gt-masonry').length > 0)
		{
			jQuery('.gt-masonry').isotope('layout');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			jQuery('.gt-grid').isotope('layout');
		}
	}
	jQuery('#showMore').on('click', function (e) {
		e.preventDefault();
		showNextItems(next_items);
	});
	hideItems(initial_items);

	function updateFilterCounts() {
		// get filtered item elements
		if(jQuery('.gt-masonry').length > 0)
		{
			var itemElems = jQuery('.gt-masonry').isotope('getFilteredItemElements');
		}
		if(jQuery('.gt-grid').length > 0)
		{
			var itemElems = jQuery('.gt-grid').isotope('getFilteredItemElements');
		}
		

		var count_items = jQuery(itemElems).length;
		

		if (count_items > initial_items) {
			jQuery('#showMore').show();
		} else {
			jQuery('#showMore').hide();
		}
		if (jQuery('.gt-filter-items').hasClass('visible_item')) {
			jQuery('.gt-filter-items').removeClass('visible_item');
		}
		var index = 0;

		jQuery(itemElems).each(function () {
			if (index >= initial_items) {
				jQuery(this).addClass('visible_item');
			}
			index++;
		});
		if(jQuery('.gt-masonry').length > 0)
		{
			jQuery('.gt-masonry').isotope('layout');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			jQuery('.gt-grid').isotope('layout');
		}
	}
	});
});