<?php
/**
 * Dynamic CSS functions
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Get dynamic CSS
 */
function uncode_get_page_dynamic_css() {
	global $uncode_post_data, $uncode_dynamic_css_selectors;

	$uncode_dynamic_css_selectors = array();

	// Get an array that contains all the raw content attached to the page
	$content_array = uncode_get_post_data_content_array();

	// Generate custom CSS for the custom colors
	$dynamic_colors_css = uncode_get_dynamic_colors_css( $content_array );

	return $dynamic_colors_css;
}

/**
 * Get dynamic CSS generated by custom colors
 */
function uncode_get_dynamic_colors_css( $content_array ) {
	$css = '';

	foreach ( $content_array as $content ) {
		if ( strpos( $content, 'uncode-gradient' ) !== false || strpos( $content, 'uncode-solid' ) !== false ) {
			$css .= uncode_get_single_dynamic_colors_css( $content );
		}
	}

	return $css;
}

/**
 * Get dynamic colors CSS from a piece of content
 */
function uncode_get_single_dynamic_colors_css( $content ) {
	$css = '';

	$regex = '/\[([^\[]+) [^\s]+_type=\"(uncode-solid|uncode-gradient)\".*?\]/m';
	preg_match_all( $regex, $content, $shortcodes, PREG_SET_ORDER, 0 );

	$shortcodes_with_colors = uncode_get_shortcodes_with_colors( $shortcodes );

	foreach ( $shortcodes_with_colors as $shortcode ) {
		$shortcode_data = uncode_get_shortcodes_with_colors_data( $shortcode );

		if ( count( $shortcode_data ) > 0 ) {
			$css .= uncode_get_dynamic_colors_css_from_shortcode( $shortcode_data );
		}
	}

	return $css;
}

/**
 * Get shortcodes that have a custom color
 */
function uncode_get_shortcodes_with_colors( $shortcodes ) {
	$shortcodes_with_colors = array();

	foreach ( $shortcodes as $key => $value ) {
		if ( isset( $value[0] ) && $value[0] && isset( $value[2] ) && $value[2] ) {
			$shortcodes_with_colors[] = $value[0];
		}
	}

	return $shortcodes_with_colors;
}

/**
 * Get data of each shortcode that has a custom color
 */
function uncode_get_shortcodes_with_colors_data( $shortcode ) {
	$regex_id = '/\[(.+?\s+)/';
	preg_match_all( $regex_id, $shortcode, $shortcode_id, PREG_SET_ORDER, 0 );

	$shortcode_data = array(
		'type'       => '',
		'id'         => '',
		'attributes' => array(),
	);

	if ( isset( $shortcode_id[0] ) && $shortcode_id[0] && isset( $shortcode_id[0][1] ) && $shortcode_id[0][1] ) {
		$shortcode_id = trim( $shortcode_id[0][1] );

		if ( $shortcode_id ) {
			$regex_attr = '/ (.*?)=\"(.*?)\"/';
			preg_match_all( $regex_attr, $shortcode, $attributes, PREG_SET_ORDER, 0 );

			$shortcode_data['type'] = $shortcode_id;

			foreach ( $attributes as $attribute ) {
				if ( isset( $attribute[1] ) && $attribute[1] && isset( $attribute[2] ) && $attribute[2] ) {
					if ( $attribute[1] === 'uncode_shortcode_id' ) {
						$shortcode_data['id'] = absint( $attribute[2] );
					} else {
						$shortcode_data['attributes'][$attribute[1]] = $attribute[2];
					}
				}
			}
		}
	}

	if ( $shortcode_data['id'] > 0 ) {
		return $shortcode_data;
	}

	return array();
}

/**
 * Get CSS from shortcode
 */
function uncode_get_dynamic_colors_css_from_shortcode( $shortcode ) {
	global $uncode_dynamic_css_selectors;

	$css = '';

	if ( isset( $shortcode['type'] ) && isset( $shortcode['id'] ) && isset( $shortcode['attributes'] ) && is_array( $shortcode['attributes'] ) ) {
		// Return early if we don't support this module
		if ( ! in_array( $shortcode['type'], uncode_get_modules_with_dynamic_colors() ) ) {
			return $css;
		}

		$shortcode_id = absint( $shortcode['id'] );

		// Check if we have already processed the same ID
		// (ie. a cloned module)
		if ( is_array( $uncode_dynamic_css_selectors ) && in_array( $shortcode_id, $uncode_dynamic_css_selectors ) ) {
			return $css;
		}

		$custom_color_keys = array();

		foreach ( $shortcode['attributes'] as $attributes_key => $attributes_value ) {
			if ( $attributes_value === 'uncode-solid' || $attributes_value === 'uncode-gradient' ) {
				$custom_color_keys[] = str_replace( '_type', '', $attributes_key );
			}
		}

		$shortcode_function_name = 'uncode_get_dynamic_colors_css_for_shortcode_' . str_replace( '-', '_', $shortcode['type'] );

		if ( function_exists( $shortcode_function_name ) ) {
			$css .= call_user_func_array( $shortcode_function_name, array( $shortcode, $custom_color_keys ) );
		}

		$uncode_dynamic_css_selectors[] = $shortcode['id'];
	}

	return $css;
}

/**
 * List of modules with dynamic colors
 */
function uncode_get_modules_with_dynamic_colors() {
	$modules = array(
		'uncode_author_profile',
		'vc_button',
		'vc_column',
		'vc_column_inner',
		'uncode_consent_notice',
		'vc_custom_heading',
		'vc_icon',
		'vc_gallery',
		'vc_message',
		'vc_row',
		'vc_row_inner',
		'vc_section',
		'vc_single_image',
		'vc_column_text',
		'vc_separator',
		'vc_gmaps',
		'vc_pie',
		'uncode_pricing',
		'uncode_list',
		'uncode_index',
		'uncode_counter',
		'uncode_vertical_text',
		'uncode_woocommerce_cart',
		'uncode_woocommerce_checkout',
		'uncode_woocommerce_my_account'
	);

	return $modules;
}
