<?php
/**
 *
 * Born To Give child theme functions and definitions
 *
 * @package Born To Give
 * @author  imithemes <www.imithemes.com>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU Public License
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 */
function borntogive_child_scripts()
{
    wp_enqueue_style('borntogive-parent-style', get_template_directory_uri() . '/style.css', array('bootstrap', 'bootstrap_theme'));
    wp_enqueue_style('datatable-min-css', get_stylesheet_directory_uri() . '/assets/datatable/jquery.dataTables.min.css');
    wp_enqueue_style('slider-css', get_stylesheet_directory_uri() . '/assets/slider.css');
    wp_enqueue_style('slick-css', get_stylesheet_directory_uri() . '/assets/slick.css');


    wp_enqueue_script('easychart', get_stylesheet_directory_uri() . '/jquery.easypiechart.min.js');
    wp_enqueue_script('datatable-min-js', get_stylesheet_directory_uri() . '/assets/datatable/jquery.dataTables.min.js');

    wp_enqueue_script('slick', get_stylesheet_directory_uri() . '/assets/slick.js');
    wp_enqueue_script('custom', get_stylesheet_directory_uri() . '/assets/custom.js');
}

add_action('wp_enqueue_scripts', 'borntogive_child_scripts');

add_action('wp_print_styles', 'tn_dequeue_font_awesome_style');
function tn_dequeue_font_awesome_style()
{
    wp_dequeue_style('font-awesome');
    wp_deregister_style('font-awesome');
}

add_shortcode('upcoming_events', 'upcomingEvents');

function upcomingEvents($attrs)
{
    $html = '';
    $today = date("Y-m-d,h:i");

    $args = array(
        'post_type' => 'event',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        'meta_query' => array(
            array(
                'key' => 'borntogive_event_start_dt',
                'value' => $today,
                'compare' => '>=',
                'type' => 'date'
            )
        )
    );

    $query = new WP_Query($args);

    if ($query->have_posts()):
        $html .= '<div class="slider">';

        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $event_start_date = get_post_meta(get_the_ID(), 'borntogive_event_start_dt', true);
            $event_end_date = get_post_meta(get_the_ID(), 'borntogive_event_end_dt', true);

            $get_day = date('d', strtotime($event_start_date));
            $get_date = date('M y', strtotime($event_start_date));

            $get_day_name = date('l h:iA', strtotime($event_start_date));
            $get_end_time = date('h:iA', strtotime($event_end_date));
            $get_location = get_post_meta(get_the_ID(), 'borntogive_event_address', true);

            $attendees = get_post_meta(get_the_ID(), 'borntogive_event_attendees', true);

            $html .= '<div>';
                $html .= '<div class="bg_image_upcoming" style="background-image: url(' . $thumbnail_image . ');"></div>';
                
                $html .= "<div class='row d-flex upcoming_events'>";
                    $html .= '<div class="col-md-4">';
                        $html .= '<div class="date_box">';
                            $html .= '<h2 class="font-bold">' . $get_day . '</h2>';
                            $html .= '<div class="divider"></div>';
                            $html .= '<h3 class="date font-bold">' . $get_date . '</h3>';
                        $html .= '</div>';
                    $html .= '</div>';
                    $html .= '<div class="col-md-8 right_content">';
                        $html .= '<h5 class="font-normal">' . $get_day_name . ' - ' . $get_end_time . '</h5>';
                        $html .= '<h2 class="event_title">' . get_the_title() . '</h2>';
                    $html .= '</div>';

                $html .= '</div>';

                $html .= '<ul class="list_event_meta">
                        <li>
                            <img src="' . get_stylesheet_directory_uri() . '/images/users.png" class="img-fluid"> Attendees <b>' . $attendees . ' | </b> 
                            <img src="' . get_stylesheet_directory_uri() . '/images/location.png" class="img-fluid"> Location <b>' . $get_location . '</b>
                        </li>  
                    </ul>';
            $html .= '</div>';
        endwhile;
        $html .= '</div>';

        endif;
    wp_reset_postdata();
    
    return $html;
}

add_shortcode('blogs_list_3', 'blogsList3');

function blogsList3()
{

    $args = array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => '3',
    );

    $query = new WP_Query($args);
    echo "<div class='row blogs_list_3'>";
    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));
            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 18, '');

            echo "<div class='col-md-4'>";
            echo '<div class="bg_image_upcoming bg_image_blog" style="background-image: url(' . $thumbnail_image . ');"></div>';
            echo "<div class='row d-flex upcoming_events'>";
            echo '<div class="col-md-4">';
            echo '<div class="date_box">';
            echo '<h1 class="font-bold">' . $get_day . '</h1>';
            echo '<div class="divider"></div>';
            echo '<h3 class="date font-bold">' . $get_date . '</h3>';
            echo '</div>';
            echo '</div>';

            echo '<div class="col-md-8 right_content">';
            //echo '<h5 class="font-normal">'.$get_day_name.' - '.$get_end_time.'</h5>';
            echo '<h1 class="event_title">' . get_the_title() . '</h1>';
            echo '<div class="description">';
            echo $description;
            echo '</div>';
            echo "<a href='" . get_the_permalink() . "' class='read-more-blog'>Read</a>";
            echo '</div>';
            echo '</div>';
            echo '</div>';
        endwhile;
    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_shortcode('blogs_list', 'blogsList');

function blogsList()
{
    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $args = array(
        'post_type' => 'post',
        's' => $search_value,
        'post_status' => 'publish',
        'posts_per_page' => 3,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type
    );

    ?>
<form action="<?php echo the_permalink(); ?>" method="post" class="d-flex" xmlns:class="http://www.w3.org/1999/xhtml">
        <div class="col-lg-4 col-sm-5 pl-0">
            <div class="search_blog_form ">
                <button class="submit_search"><i class="fas fa-search"></i></button>
                <input type="text" name="search_blog" value="<?php echo $search_value; ?>" placeholder="Search">
            </div>
        </div>
    </form>

    <ul class="d-flex orderby_ul_li">
        <!-- <li class="<?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink(); ?>">List Alphabetically</a></li> -->
        <li class="<?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink() . '/?orderby=bydate'; ?>">List by Date Added</a></li>
    </ul>
    <?php

    $query = new WP_Query($args);
    echo "<div class='row blogs_list'>";
    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));
            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 50);
            ?>
            <div class='col-sm-4'>
                <div class='border-full'>
                    <div class="bg_image_upcoming bg_image_blog"
                         style="background-image: url(<?php echo $thumbnail_image; ?>);"></div>
                    <div class='row d-flex upcoming_events'>
                        <div class="col-md-12">
                            <div class="col-md-5">
                                <div class="date_box">
                                    <h1 class="font-bold"><?php echo $get_day; ?></h1>
                                    <div class="divider"></div>
                                    <h3 class="date font-normal"><?php echo $get_date; ?></h3>
                                </div>
                            </div>

                            <div class="col-md-7 right_content">
                                <h1 class="event_title"><?php echo get_the_title(); ?></h1>
                            </div>
                        </div>
                    </div>
                    <div class="description">
                        <?php echo $description; ?>
                    </div>
                    <div class="button_red_more">
                        <a href='<?php echo get_the_permalink(); ?>' class='read-more-blog'>Read More</a>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button blogs_pagination">
            <div class="col-md-10">
                <div class="pagination">
                    <?php
                    // echo paginate_links(array(
                    //     'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                    //     'total' => $query->max_num_pages,
                    //     'current' => max(1, get_query_var('paged')),
                    //     'format' => '?paged=%#%',
                    //     'show_all' => false,
                    //     'type' => 'plain',
                    //     'end_size' => 2,
                    //     'mid_size' => 1,
                    //     'prev_next' => false,
                    //     'add_args' => false,
                    //     'add_fragment' => '',
                    // ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true"
                                                                  class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No Blogs Found</h2>';

    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_shortcode('organisation_list', 'organisationsList');

function organisationsList()
{

    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $args = array(
        'post_type' => 'openings',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        's' => $search_value,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type
    );

    $query = new WP_Query($args);

    ?>
    <form action="<?php echo the_permalink(); ?>" method="post" class="d-flex name_of_posts_class">
        <div class="col-lg-4 col-sm-5 pl-0">
            <div class="search_blog_form">
                <button class="submit_search"><i class="fas fa-search"></i></button>
                <input type="text" name="search_blog" value="<?php echo $search_value; ?>" placeholder="Search">
            </div>
        </div>
        <div>
        <select class="pl-sm-0 select_type search_blog_form h-100" name="select_type">
            <option value="select_type">Select Type</option>
            <option value="select_type">Select Type</option>
            <option value="select_type">Select Type</option>
        </select>
        <select class="pl-sm-0 select_industry search_blog_form h-100" name="select_industry">
            <option value="select_industry">Select Industry</option>
            <option value="select_industry">Select Industry</option>
            <option value="select_industry">Select Industry</option>
        </select>
        </div>
    </form>

    <ul class="d-flex orderby_ul_li openings_ul_li">
        <li class="change_class <?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="#" data-val="alphabetically">List Alphabetically</a></li>
        <li class="change_class <?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="#" data-val="bydate">List by Date Added</a></li>
    </ul>
    <div class="append_after_response">
    <?php

    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();

            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_title = get_the_title();

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));

            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 40, '');

            $org_name = get_post_meta(get_the_ID(), 'organisation_name', true);

            ?>
            <div class="row border current_openings upcoming_events mx-auto">
                <div class="col-sm-4 pl-0 hundered-100 pr-sm-0">
                    <img src="<?php echo $image_url; ?>" class="img-org">
                </div>
                <div class="col-sm-6 my-auto hundered-100">
                    <h2 class="post_title"><?php echo $post_title; ?></h2>
                    <div class="description">
                        <?php echo $description; ?>
                    </div>
                    <h4 class="org_name mb-0"><?php echo $org_name; ?></h4>
                </div>
                <div class="col-sm-2 pr-0 position-relative hundered-100">
                    <div class="date_box">
                        <h1 class="font-bold"><?php echo $get_day; ?></h1>
                        <div class="divider"></div>
                        <h3 class="date font-normal"><?php echo $get_date; ?></h3>
                    </div>
                    <div class="button_bottom">
                        <a href="<?php echo get_the_permalink(); ?>"><i class="fa fa-angle-right"></i> </a>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button">
            <div class="col-md-10">
                <div class="pagination">
                    <?php
                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true"
                                                                  class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No Organisation Found</h2>';

    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_action('wp_ajax_organisations_list', 'organisationsListAjax');
add_action('wp_ajax_nopriv_organisations_list', 'organisationsListAjax');

function organisationsListAjax()
{

    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title';
    $type = '';

    if (isset($_POST['orderby']) && !empty($_POST['orderby'])) {

        $orderby = $_POST['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $args = array(
        'post_type' => 'openings',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        's' => $search_value,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type
    );

    $query = new WP_Query($args);

    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();

            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_title = get_the_title();

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));

            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 75, '');

            $org_name = get_post_meta(get_the_ID(), 'organisation_name', true);

            ?>
            <div class="row border current_openings upcoming_events mx-auto">
                <div class="col-sm-4 pl-0 hundered-100 pr-sm-0">
                    <img src="<?php echo $image_url; ?>" class="img-org">
                </div>
                <div class="col-sm-6 my-auto hundered-100">
                    <h2 class="post_title"><?php echo $post_title; ?></h2>
                    <div class="description">
                        <?php echo $description; ?>
                    </div>
                    <h4 class="org_name mb-0"><?php echo $org_name; ?></h4>
                </div>
                <div class="col-sm-2 pr-0 position-relative hundered-100">
                    <div class="date_box">
                        <h1 class="font-bold"><?php echo $get_day; ?></h1>
                        <div class="divider"></div>
                        <h3 class="date font-normal"><?php echo $get_date; ?></h3>
                    </div>
                    <div class="button_bottom">
                        <a href="<?php echo get_the_permalink(); ?>"><i class="fa fa-angle-right"></i> </a>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button">
            <div class="col-md-10">
                <div class="pagination">
                    <?php
                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true" class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No Organisation Found</h2>';

    endif;
    wp_reset_postdata();
    die();
}

add_action( 'wp_footer', 'my_footer_scripts' );
function my_footer_scripts(){
    ?>
    <script>
        jQuery(function($){

            $(".name_of_posts_class").submit(function(e){
                e.preventDefault();

                var ajaxUrl = "<?php echo admin_url('admin-ajax.php')?>";

                var search_blog = $('input[name="search_blog"]').val();

                var select_type = $('input[name="select_type"]').val();

                var select_industry = $('input[name="select_industry"]').val();

                $.ajax({
                  url: ajaxUrl,
                  type:"POST",
                  data: {
                     action:'organisations_list',
                     search_blog:search_blog,
                     select_type:select_type,
                     select_industry:select_industry,
                },success:function(response){

                    $(".append_after_response").empty().append(response);

                    }
                });
            });

            $(".openings_ul_li a").click(function(e){
                e.preventDefault();

                $('.change_class').removeClass('active');
                $(this).parent().addClass('active');

                var ajaxUrl = "<?php echo admin_url('admin-ajax.php')?>";

                var orderby = $(this).attr('data-val');

                $.ajax({
                  url: ajaxUrl,
                  type:"POST",
                  data: {
                     action:'organisations_list',
                     orderby:orderby,
                },success:function(response){

                    $(".append_after_response").empty().append(response);

                    }
                });
            });

            $(document).ready(function () {
                $('#myTable').DataTable({
                    'bSort': true,
                    'aoColumns': [
                        { sWidth: "15%", bSearchable: false, bSortable: false },
                        { sWidth: "15%", bSearchable: true, bSortable: true },
                        { sWidth: "15%", bSearchable: true, bSortable: true },
                        { sWidth: "15%", bSearchable: true, bSortable: true },
                    ],
                    "info":           false,
                    "paging":         true,
                    "lengthChange": false,
                    "searching": false,
                    /*"responsive": true,*/
                });
            });

            $('.border_donation').click(function(){
                $('.border_donation').removeClass('active');
                $(this).addClass('active');
            });

            $(window).load(function(){

                var current_url = '<?php global $wp; echo home_url( $wp->request ); ?>';

                $('#which_job').val(current_url);

            });

            $('.chart').easyPieChart({
                size: 150,
                barColor: "#018a9c",
                scaleLength: 0,
                lineWidth: 7,
                trackColor: "transparent",
                lineBackgroundColor:"white",
                lineCap: "circle",
                animate: 2000,
            });
        });
    </script>
    <?php
}

add_shortcode('initiatives_list_one', 'initiativesListOne');

function initiativesListOne()
{    
    $args = array(
        'post_type' => 'initiatives',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        'orderby' => 'ID',
        'order' => 'ASC',
    );

    $query = new WP_Query($args);

    echo "<div class='initiative_list initiative_one'>";
    if ($query->have_posts()):
       
        echo'<div class="slider">';

        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $donated = get_post_meta(get_the_ID(),'donated',true);

            $goal = get_post_meta(get_the_ID(),'goal',true);

            $newprice = ($donated * 100) / $goal;

            ?>
            <div class=''>
                <div class='border-full'>
                    <div class="bg_image_upcoming bg_image_blog" style="background-image: url(<?php echo $thumbnail_image; ?>);"></div>
                    <div class="box">
                        <div class="chart" data-percent="<?php echo floor($newprice); ?>" ><?php echo floor($newprice); ?>%</div>
                    </div>
                    <div class='upcoming_events text-center'>
                        <h2 class="text-center event_title"><?php echo get_the_title(); ?></h2>
                        <h4 class="paid_amount">Donated <span>$<?php echo number_format($donated); ?></span></h4>
                    </div>
                    <div class="button_red_more">
                        <a href='javascript:;' class='read-more-blog'>Goal <br><span>$<?php echo number_format($goal); ?></span></a>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        
        echo'</div>';
    else:
        echo '<h2 class="text-center">No Initiatives Found</h2>';

    endif;
    wp_reset_postdata();
    echo '</div>';
}





add_shortcode('initiatives_list', 'initiativesList');

function initiativesList()
{
    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $initiative = '';

    $meta_query = '';

    if (isset($_POST['type_initiative']) && !empty($_POST['type_initiative'])) {
        $initiative = $_POST['type_initiative'];

        $meta_query = array(
            'key' => 'initiative_type',
            'value' => $initiative,
            'compare' => '='
        );
    }

    $args = array(
        'post_type' => 'initiatives',
        's' => $search_value,
        'post_status' => 'publish',
        'posts_per_page' => 3,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type,
        'meta_query' => array($meta_query)
    );

    ?>
    <form action="<?php echo the_permalink(); ?>" method="post" class="d-flex search_initiative_form search_">
        <div class="col-md-3 search_blog_form mb-sm-4">
            <button class="submit_search"><i class="fas fa-search"></i></button>
            <input type="text" name="search_blog" value="<?php echo $search_value; ?>" placeholder="Search Initiative">
        </div>
        <div class="col-md-1">

        </div>
        <div class="mb-sm-4 col-md-3 search_blog_form submit_direct <?php if($initiative == 'ongoing_initiatives') { echo 'active'; } ?>">
            <button type="submit" name="type_initiative" value="ongoing_initiatives">Ongoing Initiative</button>
        </div>
        <div class="mb-sm-4 col-md-3 search_blog_form submit_direct <?php if($initiative == 'finished_initiatives') { echo 'active'; } ?>">
            <button type="submit" name="type_initiative" value="finished_initiatives">Finished Initiative</button>
        </div>
        <div class="mb-sm-4 col-md-3 search_blog_form submit_direct <?php if($initiative == 'short_term_initiatives') { echo 'active'; } ?>">
            <button type="submit" name="type_initiative" value="short_term_initiatives">Upcoming Initiative</button>
        </div>
        <!-- <div class="mb-sm-4 col-md-3 search_blog_form submit_direct <?php if($initiative == 'long_term_initiatives') { echo 'active'; } ?>">
            <button type="submit" name="type_initiative" value="long_term_initiatives">Long Terms Initiative</button>
        </div> -->
    </form>
    <div class="clearfix"></div>
    <ul class="d-flex orderby_ul_li">
        <li class="<?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink(); ?>">List Alphabetically</a></li>
        <li class="<?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink() . '/?orderby=bydate'; ?>">List by Date Added</a></li>
    </ul>
    <?php

    $query = new WP_Query($args);
    echo "<div class='row blogs_list initiative_list'>";
    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $donated = get_post_meta(get_the_ID(),'donated',true);

            $goal = get_post_meta(get_the_ID(),'goal',true);

            $newprice = ($donated * 100) / $goal;

            $description = wp_trim_words(get_the_excerpt(), 50);
            ?>
            <div class='col-sm-4'>
                <div class='border-full'>
                    <div class="bg_image_upcoming bg_image_blog" style="background-image: url(<?php echo $thumbnail_image; ?>);"></div>
                    <div class="box">
                        <div class="chart" data-percent="<?php echo floor($newprice); ?>" ><?php echo floor($newprice); ?>%</div>
                    </div>
                    <div class='upcoming_events text-center'>
                        <h2 class="text-center event_title"><?php echo get_the_title(); ?></h2>
                        <h4 class="paid_amount">Donated <span>$<?php echo number_format($donated); ?></span></h4>
                        <h4 class="paid_amount skyblue">Goal <span>$<?php echo number_format($goal); ?></span></h4>
                    </div>
                    <div class="description text-center">
                        <?php echo $description; ?>
                    </div>
                    <div class="button_red_more">
                        <a href='<?php echo get_the_permalink(); ?>' class='read-more-blog'>Read More</a>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button blogs_pagination">
            <div class="col-md-10">
                <div class="pagination">
                    <?php
                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true"
                                                                  class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No Initiatives Found</h2>';

    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_shortcode('progreessbar_count','progressbarCount');

function progressbarCount(){

    $donated = get_post_meta(get_the_ID(),'donated',true);

    $goal = get_post_meta(get_the_ID(),'goal',true);

    $newprice = ($donated * 100) / $goal;

    return floor($newprice);
}

function countDays(){
    $now = date('Y-m-d'); // or your date as well

    $get_end_date = get_post_meta(get_the_ID(),'donation_end_date',true);

    $your_date = date('Y-m-d',strtotime($get_end_date));

    $start_date = $now;
    $end_date = $your_date;

    $date1=date_create($start_date);
    $date2=date_create($end_date);
    $diff=date_diff($date1,$date2);

    return $diff->format("%a Days Left");
}

add_shortcode('count_days','countDays');

function donorsDayTotal(){
    $totalDonors = get_post_meta(get_the_ID(),'total_donors',true);

    $donationDate = get_post_meta(get_the_ID(),'donation_end_date',true);

    $your_date = date('d.m.Y',strtotime($donationDate));

    ?>
    <div class="row">
        <div class="col-md-6 text-left">Total Donors:</div>
        <div class="col-md-6 text-right"><?php echo $totalDonors; ?></div>
    </div>
    <p></p>
    <div class="row">
        <div class="col-md-7 text-left">Donation End Date:</div>
        <div class="col-md-5 text-right"><?php echo $your_date; ?></div>
    </div>

    <?php
}

add_shortcode('donors_day_total','donorsDayTotal');

add_shortcode('resources_list', 'resourcesList');

function resourcesList()
{

    $search_value = '';

    if (isset($_POST['search_resource']) && !empty($_POST['search_resource'])) {
        $search_value = $_POST['search_resource'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $initiative = '';

    $meta_query = '';

    if (isset($_POST['type_initiative']) && !empty($_POST['type_initiative'])) {
        $initiative = $_POST['type_initiative'];

        $meta_query = array(
            'key' => 'resource_type',
            'value' => $initiative,
            'compare' => '='
        );
    }

    $args = array(
        'post_type' => 'resources',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        's' => $search_value,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type,
        'meta_query' => array($meta_query)
    );

    $query = new WP_Query($args);

    ?>
    <form action="<?php echo the_permalink(); ?>" method="post" class="d-flex search_initiative_form search_resources_form justify-content-between">
        <div class="col-sm-4 pl-0">
            <div class="search_blog_form">
                <button class="submit_search"><i class="fas fa-search"></i></button>
                <input type="text" name="search_resource" value="<?php echo $search_value; ?>" placeholder="Search">
            </div>
        </div>
       <div class="col-sm-1">

        </div>
        <div>
            <div class="col-sm-2 search_blog_form submit_direct <?php if($initiative == 'national_resources') { echo 'active'; } ?>">
                <button type="submit" name="type_initiative" value="national_resources">National Resources</button>
            </div>
            <div class="col-sm-2 search_blog_form submit_direct <?php if($initiative == 'funds_for_ngos') { echo 'active'; } ?>">
                <button type="submit" name="type_initiative" value="funds_for_ngos">Funds for NGOs</button>
            </div>
        </div>
    </form>

    <ul class="d-flex orderby_ul_li openings_ul_li">
        <li class="change_class <?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="#" data-val="alphabetically">List Alphabetically</a></li>
        <li class="change_class <?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="#" data-val="bydate">List by Date Added</a></li>
    </ul>
    <div class="append_after_response">
    <?php

    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();

            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_title = get_the_title();

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));

            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 75, '');

            ?>
            <div class="row border current_openings upcoming_events mx-auto">
                <div class="col-sm-4 pl-0 hundered-100 pr-sm-0">
                    <img src="<?php echo $image_url; ?>" class="img-org">
                    <div class="button_red_more">
                        <a href='<?php echo get_the_permalink(); ?>' class='read-more-blog'>Read More</a>
                    </div>
                </div>
                <div class="col-sm-6 my-auto hundered-100">
                    <h2 class="post_title"><?php echo $post_title; ?></h2>
                    <div class="description">
                        <?php echo $description; ?>
                    </div>
                </div>
                <div class="col-sm-2 pr-0 position-relative hundered-100">
                    <div class="date_box">
                        <h1 class="font-bold"><?php echo $get_day; ?></h1>
                        <div class="divider"></div>
                        <h3 class="date font-normal"><?php echo $get_date; ?></h3>
                    </div>
                    <div class="button_bottom">
                        <a href="<?php echo get_the_permalink(); ?>"><i class="fa fa-angle-right"></i> </a>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button">
            <div class="col-md-10">
                <div class="pagination">
                    <?php
                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true"
                                                                  class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No Resources Found</h2>';

    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_shortcode('donation_payment','donationPayment');

// Function to change email address
function wpb_sender_email($original_email_address)
{
    return 'info@acua.com';
}

// Function to change sender name
function wpb_sender_name($original_email_from)
{
    return 'Acua';
}

// Hooking up our functions to WordPress filters
add_filter('wp_mail_from', 'wpb_sender_email');
add_filter('wp_mail_from_name', 'wpb_sender_name');

function donationPayment(){
    if(isset($_POST) && !empty($_POST)){
        $payment_val = $_POST['donation_payment'];
        $full_name = $_POST['full_name'];
        $phone_number = $_POST['code'].''.$_POST['phone_number'];
        $email = $_POST['email'];
        $country = $_POST['country'];
        $city = $_POST['city'];
        $address = $_POST['address'];
        $payment_type = $_POST['payment_type'];

        $subject = "Offline Payment From User";

        $email_body = "<b>Dear admin, new offline payment from user :</b><br><br>" .
            "<b>Name :</b> $full_name <br>" .
            "<b>Email address :</b> $email <br>" .
            "<b>Amount :</b> $payment_val <br>" .
            "<b>Phone Number :</b> $phone_number <br>" .
            "<b>Country :</b> $country<br>" .
            "<b>City :</b> $city<br>" .
            "<b>Address :</b> $address<br>" .
            "<b>Payment Type :</b> $payment_type";

        $to = 'info@acuafoundation.com';

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: info@acua.com <Acua> \r\n";
        $headers .= "Reply-To: $email \r\n";

        wp_mail($to, $subject, $email_body, $headers);

        $_SESSION['message'] = 'Thanks for donation we will contact you soon.';
    }
    ?>
    <form action="<?php the_permalink(); ?>" method="post">
        <?php
            if(isset($_SESSION['message']) && !empty($_SESSION['message'])){
                echo '<div class="alert alert-success">';
                //echo '<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>';
                    echo $_SESSION['message'];
                echo '</div>';
            }
        ?>
        <div class="row align-items-center justify-content-center form-group donation_dollar">
            <div class="col-sm-2 col-centered">
                <label for="dollar_10" class="border_donation">$10.00</label>
                <input type="radio" id="dollar_10" name="donation_payment" class="hide_radio" value="10.00">
            </div>
            <div class="col-sm-2 col-centered">
                <label for="dollar_20" class="border_donation">$20.00</label>
                <input type="radio" id="dollar_20" name="donation_payment" class="hide_radio" value="20.00">
            </div>
            <div class="col-sm-2 col-centered">
                <label for="dollar_30" class="border_donation">$30.00</label>
                <input type="radio" id="dollar_30" name="donation_payment" class="hide_radio" value="30.00">
            </div>
            <div class="col-sm-2 col-centered">
                <label for="dollar_50" class="border_donation">$50.00</label>
                <input type="radio" id="dollar_50" name="donation_payment" class="hide_radio" value="50.00">
            </div>
            <div class="col-sm-2 col-centered">
                <label for="dollar_100" class="border_donation">$100.00</label>
                <input type="radio" id="dollar_100" name="donation_payment" class="hide_radio" value="100.00">
            </div>
            <div class="col-sm-2 col-centered">
                <div class="d-flex border_donation">
                    <label for="custom_amount">Custom amount</label><input type="number" id="custom_amount" name="donation_payment" value="">
                </div>
            </div>
        </div>
        <div class="details_fill_up donation_dollar">
            <div class="form-group row">
                <div class="col-sm-6">
                    <input type="text" name="full_name" required class="form-control" placeholder="Full Name*">
                </div>
                <div class="col-sm-6">
                    <div class="row">
                        <div class="col-sm-4 pr-0">
                            <input type="text" name="code" class="form-control" placeholder="Code">
                        </div>
                        <div class="col-sm-8 pl-0">
                            <input type="tel" name="phone_number" class="form-control" placeholder="Phone Number*">
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-6">
                    <input type="email" name="email" required class="form-control" placeholder="Email*">
                </div>
                <div class="col-sm-6">
                    <input type="text" name="country" required class="form-control" placeholder="Country*">
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-6">
                    <input type="text" name="city" required class="form-control" placeholder="City*">
                </div>
                <div class="col-sm-6">
                    <input type="text" name="address" required class="form-control" placeholder="Address*">
                </div>
            </div>
        </div>
        <div class="details_fill_up donation_dollar">
        <label class="pl-0">Payment Type</label>
        <div class="row">
                <div class="col-md-3">
                  <label class="radio_button">&nbsp;&nbsp;Offline Donation
                      <input type="radio" checked="checked" id="offline" name="payment_type">
                      <span class="checkmark"></span>
                  </label>
                </div>
                <div class="col-md-3">
                    <label class="radio_button" for="paypal">&nbsp;&nbsp;PayPal
              <input type="radio" name="payment_type" id="paypal">
              <span class="checkmark"></span>
            </label>
                </div>
                <div class="col-md-3">
                    <label class="radio_button" for="visa_master">&nbsp;&nbsp;Visa/Master Card
              <input type="radio" name="payment_type" id="visa_master">
              <span class="checkmark"></span>
            </label>
                </div>
            </div>
        </div>
         <div class="details_fill_up donation_dollar text-center">
            <input type="submit" name="donate" value="DONATE" class="btn-submit">
        </div>
    </form>
    <?php
}

add_shortcode('news_list', 'newsList');

function newsList()
{

    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $args = array(
        'post_type' => 'news',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        's' => $search_value,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type
    );

    $query = new WP_Query($args);

    ?>
    <form action="<?php echo the_permalink(); ?>" method="post" class="d-flex search_news_form">
        <div class="col-sm-5">
            <div class="search_blog_form">
                <button class="submit_search"><i class="fas fa-search"></i></button>
                <input type="text" name="search_blog" value="<?php echo $search_value; ?>" placeholder="Search">
            </div>
        </div>
        <div class="col-sm-3">
            <select class="select_type search_blog_form" name="select_type">
                <option value="select_type">Select Date</option>
                <option value="select_type">Select Date</option>
                <option value="select_type">Select Date</option>
            </select>
        </div>
        <div class="col-sm-3">
            <select class="select_industry search_blog_form" name="select_industry">
                <option value="select_industry">Select Industry</option>
                <option value="select_industry">Select Industry</option>
                <option value="select_industry">Select Industry</option>
            </select>
        </div>
    </form>

    <ul class="d-flex orderby_ul_li">
        <li class="change_class <?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink().'/?orderby=alphabetically'; ?>" data-val="alphabetically">List Alphabetically</a></li>
        <li class="change_class <?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink().'?orderby=bydate'; ?>" >List by Date Added</a></li>
    </ul>
    <div class="">
    <?php

    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();

            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_title = get_the_title();

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));

            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 75, '');

            ?>
            <div class="row border current_openings upcoming_events mx-auto">
                <div class="col-sm-4 pl-0 hundered-100 pr-sm-0">
                    <img src="<?php echo $image_url; ?>" class="img-org">
                    <div class="button_red_more">
                        <a href='<?php echo get_the_permalink(); ?>' class='read-more-blog'>Read More</a>
                    </div>
                </div>
                <div class="col-sm-6 my-auto hundered-100">
                    <h2 class="post_title"><?php echo $post_title; ?></h2>
                    <div class="description">
                        <?php echo $description; ?>
                    </div>
                </div>
                <div class="col-sm-2 pr-0 position-relative hundered-100">
                    <div class="date_box">
                        <h1 class="font-bold"><?php echo $get_day; ?></h1>
                        <div class="divider"></div>
                        <h3 class="date font-normal"><?php echo $get_date; ?></h3>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button">
            <div class="col-md-10">
                <div class="pagination">
                    <?php
                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true"
                                                                  class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No News Found</h2>';

    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_shortcode('news_all', 'newsAll');

function newsAll()
{

    $args = array(
        'post_type' => 'news',
        'post_status' => 'publish',
        'posts_per_page' => '3',
    );

    $query = new WP_Query($args);
echo "<div class='row blogs_list'>";
    if ($query->have_posts()):
        while ($query->have_posts()):

            $query->the_post();

            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));

            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 28, '');
            echo "<div class='col-sm-4'>";
                echo "<div class='border-full'>";
                    echo '<div class="bg_image_upcoming mt-0" style="background-image: url(' . $thumbnail_image . ');"></div>';
                    echo "<div class='row d-flex upcoming_events'>";
                    echo '<div class="col-md-4 pr-0 pl-30-px">';
                    echo '<div class="date_box">';
                    echo '<h2 class="font-bold">' . $get_day . '</h2>';
                    echo '<div class="divider"></div>';
                    echo '<h3 class="date font-normal">' . $get_date . '</h3>';
                    echo '</div>';
                    echo '</div>';

                    echo '<div class="col-md-8 right_content">';
                    echo '<h2 class="event_title">' . get_the_title() . '</h2>';
                    echo '</div>';
                    ?>
                    <div class="col-md-12">
                        <div class="description">
                            <?php echo $description; ?>
                        </div>
                    </div>
                    <?php
                    echo '</div>';
                    ?>
                    <div class="button_red_more">
                        <a href='<?php echo get_the_permalink(); ?>' class='read-more-blog'>Read More</a>
                    </div>
<?php
                echo '</div>';
            echo '</div>';
        endwhile;
    endif;
    echo '</div>';
    wp_reset_postdata();
}

/*blog list without current blog show*/

add_shortcode('blogs_list_3_other', 'blogsListOther3');

function blogsListOther3()
{

    $args = array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => '3',
        'post__not_in' => array(get_the_ID())
    );

    $query = new WP_Query($args);
    echo "<div class='row blogs_list_3 blogs_list'>";
    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $post_date = get_the_date();

            $get_day = date('d', strtotime($post_date));
            $get_date = date('M y', strtotime($post_date));

            $description = wp_trim_words(get_the_excerpt(), 18, '');

            echo "<div class='col-sm-4'>";
                echo "<div class='border-full'>";
                    echo '<div class="bg_image_upcoming mt-0" style="background-image: url(' . $thumbnail_image . ');"></div>';
                    echo "<div class='row d-flex upcoming_events'>";
                    echo '<div class="col-md-4 pr-0 pl-30-px">';
                    echo '<div class="date_box">';
                    echo '<h2 class="font-bold">' . $get_day . '</h2>';
                    echo '<div class="divider"></div>';
                    echo '<h3 class="date font-normal">' . $get_date . '</h3>';
                    echo '</div>';
                    echo '</div>';

                    echo '<div class="col-md-8 right_content">';
                    echo '<h2 class="event_title">' . get_the_title() . '</h2>';
                    echo '</div>';
                    ?>
                    <div class="col-md-12">
                        <div class="description">
                            <?php echo $description; ?>
                        </div>
                    </div>
                    <?php
                    echo '</div>';
                    ?>
                    <div class="button_red_more">
                        <a href='<?php echo get_the_permalink(); ?>' class='read-more-blog'>Read More</a>
                    </div>
<?php
                echo '</div>';
            echo '</div>';
        endwhile;
    endif;
    wp_reset_postdata();
    echo '</div>';
}

add_shortcode('ngo_directory_list', 'ngoDirectoryList');

function ngoDirectoryList()
{
    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $args = array(
        'post_type' => 'ngo_directory',
        's' => $search_value,
        'post_status' => 'publish',
        'posts_per_page' => 5,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type
    );

    ?>
    <form action="<?php echo the_permalink(); ?>" method="post" class="d-flex justify-content-between">
        <div class="col-lg-4 col-sm-6 pl-0">
            <select class="search_blog_form w-100 select-industry-ngo" name="select_industry">
                <option value="select_industry">Select Industry</option>
                <option value="select_industry">Select Industry</option>
                <option value="select_industry">Select Industry</option>
            </select>
            <div class="search_blog_form ml-0 w-80">
                <button class="submit_search"><i class="fas fa-search"></i></button>
                <input type="text" name="search_blog" value="<?php echo $search_value; ?>" placeholder="Search NGO">
            </div>
        </div>
        <div class="col-sm-4 pr-0 text-right">
            <button type="button" name="add_ngo" class="add_ngo_btn" id="ngo_btn_popup">Add Ngo</button>
        </div>
    </form>

    <ul class="d-flex orderby_ul_li">
        <li class="<?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink(); ?>">List Alphabetically</a></li>
        <li class="<?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink() . '/?orderby=bydate'; ?>">List by Date Added</a></li>
    </ul>
    <?php
    echo '<div class="width-767">';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        echo '<table class="table table-responsive table-ngo-directory" id="myTable">';
        ?>
        <thead>
        <tr>
            <th class="bg-transparent"></th>
            <th>Name</th>
            <th>Industry</th>
            <th>Date</th>
         </tr>
        </thead>
        <?php
            while ($query->have_posts()):
                $query->the_post();
                $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

                $post_date = get_the_date();

                $get_date = date('d . M . y', strtotime($post_date));

                $industry_text = get_post_meta(get_the_ID(),'industry',true);
                ?>
                 <tr>
                    <td class="border_bottom_0"><img src="<?php echo $thumbnail_image; ?>" class="img-fluid"> </td>
                    <td><?php echo get_the_title(); ?></td>
                    <td><?php echo $industry_text; ?></td>
                    <td><?php echo $get_date; ?></td>
                 </tr>
                <?php
            endwhile;
        echo '</table>';
        ?>
        <div class="clearfix"></div>
        <div class="pagination_button blogs_pagination">
            <div class="col-sm-offset-3 col-md-7 pl-0">
                <!--<div class="pagination">
                    <?php
/*                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    */?>
                </div>-->
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true" class="fas fa-arrow-right"></i></a>
            </div>
        </div>
        <?php
    else:
        echo '<h2 class="text-center">No Blogs Found</h2>';

    endif;
    echo '</div>';
    wp_reset_postdata();
}

add_shortcode('events_all', 'eventsAll');

function eventsAll()
{

    //$today = date("Y-m-d,h:i");

    $search_value = '';

    if (isset($_POST['search_blog']) && !empty($_POST['search_blog'])) {
        $search_value = $_POST['search_blog'];
    }

    $ordername = 'post_title    ';
    $type = '';

    $orderby = 'alphabetically';

    if (isset($_GET['orderby']) && !empty($_GET['orderby'])) {

        $orderby = $_GET['orderby'];

        if ($orderby == '') {
            $ordername = 'post_title';
        }

        if ($orderby == 'bydate') {
            $ordername = 'date';
            $type = 'date';
        }
    }

    $args = array(
        'post_type' => 'event',
        's' => $search_value,
        'post_status' => 'publish',
        'posts_per_page' => 5,
        'paged' => get_query_var('paged'),
        'orderby' => $ordername,
        'order' => 'ASC',
        'type' => $type
        /*'meta_query' => array(
            array(
                'key' => 'borntogive_event_start_dt',
                'value' => $today,
                'compare' => '>=',
                'type' => 'date'
            )
        )*/
    );

    $query = new WP_Query($args);

    ?>
    <form action="<?php echo the_permalink(); ?>" method="post" class="d-flex justify-content-between events_search_bar">
        <div class="col-sm-8 pl-0">
            <div class="col-lg-4 col-sm-8 pl-0 mb-sm-4">
                <div class="search_blog_form search_value">
                    <button class="submit_search"><i class="fas fa-search"></i></button>
                    <input type="text" name="search_blog" value="<?php echo $search_value; ?>" placeholder="Search">
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <select class="search_blog_form w-100" name="select_type">
                    <option value="select_type">Select Type</option>
                    <option value="select_type">Select Type</option>
                    <option value="select_type">Select Type</option>
                </select>
            </div>
            <div class="col-lg-4 col-sm-6">
                <select class="search_blog_form w-100" name="select_industry">
                    <option value="select_industry">Select Industry</option>
                    <option value="select_industry">Select Industry</option>
                    <option value="select_industry">Select Industry</option>
                </select>
        </div>
        </div>
        <div class="col-sm-2">
            <a href="#events_calendar" class="calendar_button">View Calendar</a>
        </div>
    </form>

    <ul class="d-flex orderby_ul_li">
        <li class="<?php if ($orderby == 'alphabetically') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink(); ?>">List Alphabetically</a></li>
        <li class="<?php if ($orderby == 'bydate') {
            echo 'active';
        } ?>"><a href="<?php echo the_permalink() . '/?orderby=bydate'; ?>">List by Date Added</a></li>
    </ul>
    <?php
    if ($query->have_posts()):
    echo "<div class='row blogs_list events_list'>";
        while ($query->have_posts()):
            $query->the_post();
            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $event_start_date = get_post_meta(get_the_ID(), 'borntogive_event_start_dt', true);
            $event_end_date = get_post_meta(get_the_ID(), 'borntogive_event_end_dt', true);

            $get_day = date('d', strtotime($event_start_date));
            $get_date = date('M y', strtotime($event_start_date));

            $get_day_name = date('l h:iA', strtotime($event_start_date));
            $get_end_time = date('h:iA', strtotime($event_end_date));
            $get_location = get_post_meta(get_the_ID(), 'borntogive_event_address', true);

            $attendees = get_post_meta(get_the_ID(), 'borntogive_event_attendees', true);
            echo '<div class="col-lg-4 col-sm-6">';
                echo "<div class='border-full'>";
                        echo '<div class="mt-0 bg_image_upcoming" style="background-image: url(' . $thumbnail_image . ');"></div>';
                        echo '<div class="p-3">';
                        echo "<div class='row d-flex upcoming_events'>";
                        echo '<div class="col-md-4">';
                        echo '<div class="date_box">';
                        echo '<h2 class="font-bold">' . $get_day . '</h2>';
                        echo '<div class="divider"></div>';
                        echo '<h3 class="date font-bold">' . $get_date . '</h3>';
                        echo '</div>';
                        echo '</div>';

                        echo '<div class="col-md-8 right_content">';
                        echo '<h5 class="font-normal">' . $get_day_name . ' - ' . $get_end_time . '</h5>';
                        echo '<h2 class="event_title">' . get_the_title() . '</h2>';
                        echo '</div>';
                        echo '</div>';
                    echo '</div>';
                    echo '<div class="bottom-zero-event">';
                    echo '<ul class="list_event_meta">
                              <li>
                                  <img src="' . get_stylesheet_directory_uri() . '/images/users.png" class="img-fluid"> Attendees <b>' . $attendees . '</b> 
                                  <img src="' . get_stylesheet_directory_uri() . '/images/location.png" class="img-fluid"> Location <b>' . $get_location . '</b>
                              </li>
                           </ul>';
                    echo "<div class='button_red_more'>
                            <a href='".get_the_permalink()."' class='read-more-blog'>Read More</a>
                          </div>";
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        endwhile;
        echo '</div>';
    endif;
    ?>
    <div class="clearfix"></div>
        <div class="pagination_button blogs_pagination">
            <div class="col-sm-offset-3 col-md-7 pl-0">
                <div class="pagination">
                    <?php
                    echo paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => false,
                        'add_args' => false,
                        'add_fragment' => '',
                    ));
                    ?>
                </div>
            </div>
            <div class="col-md-2 see_all_button text-right">
                <a href="<?php home_url('/blogs'); ?>">See all <i aria-hidden="true" class="fas fa-arrow-right"></i></a>
            </div>
        </div>
    <?php
    wp_reset_postdata();
}

add_shortcode('featured_images_with_date','featuredImageWithDate');

function featuredImageWithDate(){
    $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');

    $event_start_date = get_post_meta(get_the_ID(), 'borntogive_event_start_dt', true);

    $event_end_date = get_post_meta(get_the_ID(), 'borntogive_event_end_dt', true);

    $post_date = get_the_date();

    $get_day = date('d', strtotime($post_date));

    $get_date = date('M y', strtotime($post_date));

    $get_day_name = date('l', strtotime($event_start_date));

    $get_start_time = date('h:iA', strtotime($event_start_date));

    $get_end_time = date('h:iA', strtotime($event_end_date));

    $get_location = get_post_meta(get_the_ID(), 'borntogive_event_address', true);

    $attendees = get_post_meta(get_the_ID(), 'borntogive_event_attendees', true);

    ?>
    <div class="upcoming_events event_featured_image mx-auto">
        <div class="position-relative">
            <div class="bg-dark-overlay"></div>
            <img src="<?php echo $image_url; ?>" class="img-org">
        </div>
        <div class="button_red_more">
            <a href='javascript:;' class='read-more-blog'>Join Now</a>
        </div>
        <div class="top-zero">
            <div class="col-sm-4">
                <div class="date_box">
                    <h2 class="font-bold"><?php echo $get_day; ?></h2>
                    <div class="divider"></div>
                    <h3 class="date font-bold"><?php echo $get_date; ?></h3>
                </div>
            </div>

            <div class="col-sm-8 right_content">
                <h5 class="font-normal"><?php echo $get_day_name .'<br>'. $get_start_time . ' - ' . $get_end_time; ?></h5>
            </div>
        </div>

        <ul class="list_event_meta">
            <li>
                <img src="<?php echo get_stylesheet_directory_uri().'/images/users.png'; ?>" class="img-fluid"> Attendees <b><?php echo $attendees; ?> </b>
            </li>
            <li class="pt-4">
                <img src="<?php echo get_stylesheet_directory_uri().'/images/location.png'; ?>" class="img-fluid"> Location <b><?php echo $get_location; ?></b>
            </li>
        </ul>
    </div>
    <?php
}

add_shortcode('events_last_three', 'eventsThree');

function eventsThree()
{

    //$today = date("Y-m-d,h:i");

    $args = array(
        'post_type' => 'event',
        'post_status' => 'publish',
        'posts_per_page' => 3,
        'post__not_in' => array(get_the_ID())
        /*'meta_query' => array(
            array(
                'key' => 'borntogive_event_start_dt',
                'value' => $today,
                'compare' => '>=',
                'type' => 'date'
            )
        )*/
    );

    $query = new WP_Query($args);

    if ($query->have_posts()):
    echo "<div class='row blogs_list events_list'>";
        while ($query->have_posts()):

            $query->the_post();

            $thumbnail_image = get_the_post_thumbnail_url(get_the_ID(), 'full');

            $event_start_date = get_post_meta(get_the_ID(), 'borntogive_event_start_dt', true);

            $event_end_date = get_post_meta(get_the_ID(), 'borntogive_event_end_dt', true);

            $get_day = date('d', strtotime($event_start_date));
            $get_date = date('M y', strtotime($event_start_date));

            $get_day_name = date('l h:iA', strtotime($event_start_date));
            $get_end_time = date('h:iA', strtotime($event_end_date));
            $get_location = get_post_meta(get_the_ID(), 'borntogive_event_address', true);

            $attendees = get_post_meta(get_the_ID(), 'borntogive_event_attendees', true);
            echo '<div class="col-sm-4">';
                echo "<div class='border-full'>";
                        echo '<div class="mt-0 bg_image_upcoming" style="background-image: url(' . $thumbnail_image . ');"></div>';
                        echo '<div class="p-3">';
                        echo "<div class='row d-flex upcoming_events'>";
                        echo '<div class="col-md-4">';
                        echo '<div class="date_box">';
                        echo '<h2 class="font-bold">' . $get_day . '</h2>';
                        echo '<div class="divider"></div>';
                        echo '<h3 class="date font-bold">' . $get_date . '</h3>';
                        echo '</div>';
                        echo '</div>';

                        echo '<div class="col-md-8 right_content">';
                        echo '<h5 class="font-normal">' . $get_day_name . ' - ' . $get_end_time . '</h5>';
                        echo '<h2 class="event_title">' . get_the_title() . '</h2>';
                        echo '</div>';
                        echo '</div>';
                    echo '</div>';
                    echo '<div class="bottom-zero-event">';
                        echo '<ul class="list_event_meta">
                                    <li>
                                        <img src="' . get_stylesheet_directory_uri() . '/images/users.png" class="img-fluid"> Attendees <b>' . $attendees . '</b> 
                                        <img src="' . get_stylesheet_directory_uri() . '/images/location.png" class="img-fluid"> Location <b>' . $get_location . '</b>
                                    </li>  
                               </ul>';
                        echo "<div class='button_red_more'>
                                <a href='".get_the_permalink()."' class='read-more-blog'>Read More</a>
                              </div>";
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        endwhile;
        echo '</div>';
    endif;
    ?>
    <?php
    wp_reset_postdata();
}

add_shortcode('facebook_share','facebookShare');

function facebookShare(){
    return 'https://www.facebook.com/sharer?u='.get_the_permalink().'&t='.get_the_title().'';
}

add_shortcode('twitter_share','twitterShare');

function twitterShare(){
    return 'https://twitter.com/intent/tweet?text='.get_the_title().'&url='.get_the_permalink().'';
}

add_shortcode('linkedin_share','linkedinShare');

function linkedinShare(){
    return 'https://www.linkedin.com/shareArticle?url='.get_the_permalink().'&title='.get_the_title().'';
}

add_shortcode('whatsapp_share','whatsappShare');

function whatsappShare(){
    return 'https://wa.me/?text='.get_the_permalink().'';
}

add_shortcode('email_share','emailShare');

function emailShare(){
    return 'mailto:?subject='.get_the_title().'&body='.get_the_permalink().'."';
}

add_shortcode('ngo_popup_form','ngoPopupForm');

function ngoPopupForm(){
    if(isset($_POST) && !empty($_POST)){
        $ngo_name = $_POST['ngo_official_name'];
        $acronym = $_POST['acronym'];
        $licence_number = $_POST['licence_number'];
        $phone_number = $_POST['code'].''.$_POST['phone_number'];
        $email = $_POST['email'];
        $city = $_POST['city'];
        $address = $_POST['address'];
        $website_url = $_POST['website_url'];
        $social_links = $_POST['social_links'];
        $details = $_POST['details'];

        $subject = "Add Ngo Request From User";

        $email_body = "<b>Dear admin, new ngo add request from user :</b><br><br>" .
            "<b>Ngo Official Name :</b> $ngo_name <br>" .
            "<b>Email address :</b> $email <br>" .
            "<b>Acronym :</b> $acronym <br>" .
            "<b>Phone Number :</b> $phone_number <br>" .
            "<b>Licence Number :</b> $licence_number<br>" .
            "<b>City :</b> $city<br>" .
            "<b>Address :</b> $address<br>" .
            "<b>Website Url :</b> $website_url<br>".
            "<b>Social Links :</b> $social_links";

        $to = 'info@acuafoundation.com';

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: info@acua.com <Acua> \r\n";
        $headers .= "Reply-To: $email \r\n";

        $post_main_data = array(
            'post_type' => 'ngo_directory',
            'post_title' => $ngo_name,
            'post_status' => 'draft',
        );

        $post_id = wp_insert_post($post_main_data);

        $final_post_id = $post_id;

        $post_meta_data = array(
            'ngo_official_name' => $ngo_name,
            'acronyms' => $acronym,
            'ngo_license_number' => $licence_number,
            'phone_number' => $phone_number,
            'email' => $email,
            'city' => $city,
            'address' => $address,
            'details' => $details,
            'website_url' => $website_url,
            'social_media_url' => $social_links
        );

        foreach($post_meta_data as $key=>$meta_data){
            update_post_meta($final_post_id,$key,$meta_data);
        }

        wp_mail($to, $subject, $email_body, $headers);

        $_SESSION['message'] = 'Thanks for add ngo request we will add ngo soon.';
    }
    ?>
    <form action="<?php echo the_permalink(); ?>" method="post">
    <?php
            if(isset($_SESSION['message']) && !empty($_SESSION['message'])){
                echo '<div class="alert alert-success">';
                //echo '<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>';
                    echo $_SESSION['message'];
                echo '</div>';
            }
        ?>
        <div class="ngo_directory_form">
            <div class="row form-group">
                <div class="col-sm-9">
                    <input type="text" name="ngo_official_name" class="form-control" placeholder="NGO Official Name*" required>
                </div>
                <div class="col-sm-3">
                    <input type="text" name="acronym" class="form-control" placeholder="Acronyms">
                </div>
            </div>
            <div class="row form-group">
                <div class="col-sm-6">
                    <input type="text" name="licence_number" required class="form-control" placeholder="NGO License Number*">
                </div>
                <div class="col-sm-6">
                    <div class="row">
                        <div class="col-sm-3 pr-0">
                            <input type="tel" name="code" placeholder="Code" class="form-control border-right-0">
                        </div>
                        <div class="pl-0 col-sm-9">
                            <input type="tel" name="phone_number" placeholder="Phone Number*" class="form-control ">
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex row form-group mb-0">
                <div class="col-sm-6">
                    <input type="email" required name="email" class="form-control" placeholder="Email*">
                </div>
                <div class="col-sm-6">
                    <input type="text" required name="city" class="form-control" placeholder="City*">
                </div>
            </div>
            <div class="form-group">
                <input type="text" required name="address" class="form-control" placeholder="Address*">
            </div>

            <div class="form-group">
                <textarea required name="details" class="form-control" rows="5" placeholder="Details"></textarea>
            </div>
        </div>
        <div class="ngo_directory_form social_links">
            <div class="form-group">
                <input type="url" name="website_url" class="form-control border-0 border-bottom-1" placeholder="Website URL">
            </div>
            <div class="form-group">
                <label class="w-100 margin-bottom-custom">Facebook / Twitter / Instagram<br>Separate URLs with /</label>
                <input type="text" name="social_links" class="form-control border-0 border-bottom-1" placeholder="Social Media URL">
            </div>
        </div>
        <div class="form-group buttons_div text-center">
             <input type="submit" class="submit_btn" value="SUBMIT">
        </div>
    </form>
    <?php
}

?>